<?php

namespace BisnNotify\Hooks;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Ajax class
 */
class Ajax {
	public function __construct() {
		add_action('wp_ajax_back_in_stock_notify', [$this, 'back_in_stock_notify_handle_notification_request']);
		add_action('wp_ajax_nopriv_back_in_stock_notify', [$this, 'back_in_stock_notify_handle_notification_request']);		
	}

	function back_in_stock_notify_handle_notification_request() {
		// Verify nonce for security
		check_ajax_referer('back_in_stock_notify_nonce', 'nonce');
	
		// Validate and sanitize inputs
		$email = isset($_POST['email']) ? sanitize_email(wp_unslash($_POST['email'])) : '';
		$product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
	
		// Validate product ID
		if (!$product_id) {
			wp_send_json_error(['message' => __('Invalid product ID.', 'back-in-stock-notify')]);
		}
	
		// Validate email address
		if (empty($email) || !is_email($email)) {
			wp_send_json_error(['message' => __('Invalid email address.', 'back-in-stock-notify')]);
		}
	
		// Get existing notifications
		$notifications = get_post_meta($product_id, '_back_in_stock_notify_notifications', true);
		$notifications = is_array($notifications) ? $notifications : [];
	
		// Add email if not already in notifications
		if (!in_array($email, $notifications)) {
			$notifications[] = $email;
			update_post_meta($product_id, '_back_in_stock_notify_notifications', $notifications);
		}
	
		// Send success response
		wp_send_json_success(['message' => __('You will be notified when the product is back in stock!', 'back-in-stock-notify')]);
	}
}
