jQuery(document).ready(function ($) {
	$('#bisn-submit').on('click', function () {
		const email = $('#bisn-email').val();
		const productId = BISN_Ajax.product_id; // Ensure this value is available

		$.post(BISN_Ajax.ajax_url, {
			action: 'back_in_stock_notify',
			nonce: BISN_Ajax.nonce,
			email: email,
			product_id: productId, // Send product_id in the request
		}).done(function (response) {
			// Hide input field and button
			$('#bisn-email, #bisn-submit').hide();
			
			// Show the response message
			$('#bisn-message').text(response.data.message).show();

			// Reset the input field
			$('#bisn-email').val('');

			// After 3 seconds, hide the message and show the input and button again
			setTimeout(function () {
				$('#bisn-message').fadeOut();
				$('#bisn-email, #bisn-submit').fadeIn();
			}, 3000);
		}).fail(function (error) {
			// Show error message
			$('#bisn-message').text(error.responseJSON.data.message).show();
		});
	});
});
