<?php
/**
 * ملف إلغاء التثبيت لإضافة Bots Tracker
 *
 * مهم:
 * - هذا الملف يتم تشغيله فقط عند حذف الإضافة نهائيًا من لوحة التحكم (Delete).
 * - لا يتم تشغيله عند تعطيل الإضافة فقط (Deactivate).
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// 1) حذف جدول الزيارات من قاعدة البيانات
global $wpdb;

// اسم الجدول مع البادئة الحالية
$table_name = $wpdb->prefix . 'bots_visits';

// حذف الجدول إن وجد
$wpdb->query( "DROP TABLE IF EXISTS {$table_name}" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

// 2) حذف جميع الخيارات (options) الخاصة بالإضافة من wp_options
// IMPORTANT: حدّث هذه القائمة لتشمل كل الإعدادات التي تستخدمها الإضافة فعليًا
$options = array(
    'bt_bots_retention_days',
    'bt_bots_crawl_retention_days',
    'bt_bots_filter_enabled',
    'bt_bots_filter_mode',
    'bt_bots_filter_source',
    'bt_bots_filter_selected_bots',
);

// لو لاحقًا أضفت خيارات أخرى للبلاجن، يمكنك إضافتها هنا أيضاً مثلاً:
// $options[] = 'bt_bots_tracker_some_setting';

// حذف الخيارات من الموقع العادي أو من الشبكة (في حالة MultiSite)
foreach ( $options as $option_name ) {
    delete_option( $option_name );
    delete_site_option( $option_name ); // في حالة كانت مُسجّلة على مستوى الشبكة
}

// 3) إلغاء جدولة أي أحداث Cron خاصة بالإضافة (مثل حدث تنظيف السجلات)
if ( function_exists( 'wp_clear_scheduled_hook' ) ) {
    // تأكد أن اسم الهوك هو نفس الاسم الذي استخدمته في wp_schedule_event
    wp_clear_scheduled_hook( 'bt_bots_tracker_cleanup_event' );
}

/**
 * ملاحظات مهمة:
 *
 * - ما يتم حذفه فقط هو:
 *   1) جدول الزيارات الذي أنشأته الإضافة داخل قاعدة بيانات ووردبريس.
 *   2) جميع الإعدادات (options) التي استخدمتها الإضافة للتخزين.
 *   3) أي أحداث مجدولة (Cron) خاصة بالإضافة.
 *
 * - بعد هذه العملية، لا يبقى في ووردبريس أي أثر لبيانات الإضافة.
 */
