<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * دوال مساعدة عامة لإضافة Bots Tracker
 * يمكن استخدامها في أي مكان داخل الإضافة لتوحيد التنسيق والمنطق.
 */

/**
 * عرض تابات صفحات الإضافة في أعلى كل صفحة (آخر الزيارات – ميزانية الزحف – الإعدادات)
 *
 * @param string $active  الـ slug الخاص بالصفحة النشطة حالياً (page=...)
 */
if ( ! function_exists( 'bt_bots_render_tabs' ) ) {

    function bt_bots_render_tabs( $active = '' ) {

        // تعريف التابات: slug => label
        $tabs = array(
            'bt-bots-tracker'      => __( 'Bot visits', 'azayem-bots-tracker' ),
            'bt-bots-crawl-budget' => __( 'Crawl budget', 'azayem-bots-tracker' ),
            'bt-bots-setting'      => __( 'Settings', 'azayem-bots-tracker' ),
        );

        echo '<h2 class="nav-tab-wrapper bt-bots-nav-tabs">';

        foreach ( $tabs as $slug => $label ) {

            $class = ( $active === $slug ) ? 'nav-tab nav-tab-active' : 'nav-tab';

            $url = admin_url( 'admin.php?page=' . $slug );

            echo '<a class="' . esc_attr( $class ) . '" href="' . esc_url( $url ) . '">'
                    . esc_html( $label ) .
                 '</a>';
        }

        echo '</h2>';
    }
}
