/**
 * Bots Tracker - Admin Scripts
 *
 * هذا الملف لأكواد JavaScript الخاصة بلوحة التحكم في إضافة Bots Tracker.
 */

(function () {
    'use strict';

    /**
     * إظهار / إخفاء صفوف إعدادات الفلتر حسب التفعيل + المصدر
     */
    function refreshBotFilterVisibility() {
        var enabledCheckbox = document.getElementById('bt_bots_filter_enabled');
        var modeRow         = document.getElementById('bt-bots-filter-mode-row');
        var sourceRow       = document.getElementById('bt-bots-filter-source-row');
        var storedRow       = document.querySelector('.bt-bots-filter-row-stored');
        var customRow       = document.querySelector('.bt-bots-filter-row-custom');

        var enabled = enabledCheckbox && enabledCheckbox.checked;

        if (modeRow) {
            modeRow.style.display = enabled ? '' : 'none';
        }
        if (sourceRow) {
            sourceRow.style.display = enabled ? '' : 'none';
        }

        var storedSelected = document.querySelector('input[name="bt_bots_filter_source"][value="stored"]:checked');
        var customSelected = document.querySelector('input[name="bt_bots_filter_source"][value="custom"]:checked');

        if (storedRow) {
            storedRow.style.display = (enabled && storedSelected) ? '' : 'none';
        }
        if (customRow) {
            customRow.style.display = (enabled && customSelected) ? '' : 'none';
        }
    }

    /**
     * منطق تخزين اختيارات البوتات لكل وضع (include / exclude) داخل الجلسة
     */
    var modeSelections = {
        include: [],
        exclude: []
    };

    var multiSelectState = {
        original: null,
        button: null,
        labelNone: 'Select bots',
        labelMany: 'bots selected'
    };

    function getCurrentMode() {
        var filterModeSelect = document.getElementById('bt_bots_filter_mode');
        var value = filterModeSelect ? filterModeSelect.value : 'exclude';
        return (value === 'include') ? 'include' : 'exclude';
    }

    function getCurrentSelection() {
        var selected = [];
        if (!multiSelectState.original) {
            return selected;
        }
        var options = multiSelectState.original.options;
        for (var i = 0; i < options.length; i++) {
            if (options[i].selected) {
                selected.push(options[i].value);
            }
        }
        return selected;
    }

    function setSelection(values) {
        if (!multiSelectState.original) {
            return;
        }

        var valueMap = {};
        var i;

        if (values && values.length) {
            for (i = 0; i < values.length; i++) {
                valueMap[ values[i] ] = true;
            }
        }

        var options = multiSelectState.original.options;
        for (i = 0; i < options.length; i++) {
            options[i].selected = !!valueMap[ options[i].value ];
        }

        var checkboxes = document.querySelectorAll('.bt-bots-multiselect-menu input[type="checkbox"]');
        if (checkboxes && checkboxes.length) {
            for (i = 0; i < checkboxes.length; i++) {
                checkboxes[i].checked = !!valueMap[ checkboxes[i].value ];
            }
        }

        updateButtonLabel();
    }

    function updateButtonLabel() {
        if (!multiSelectState.original || !multiSelectState.button) {
            return;
        }
        var options = multiSelectState.original.options;
        var selected = [];
        for (var i = 0; i < options.length; i++) {
            if (options[i].selected) {
                selected.push(options[i].text);
            }
        }

        if (selected.length === 0) {
            multiSelectState.button.textContent = multiSelectState.labelNone;
        } else if (selected.length === 1) {
            multiSelectState.button.textContent = selected[0];
        } else {
            multiSelectState.button.textContent =
                selected.length + ' ' + multiSelectState.labelMany;
        }
    }

    /**
     * تحويل الـ <select multiple> إلى قائمة منسدلة مع Checkboxes
     */
    function initBotMultiSelect() {
        var original = document.getElementById('bt_bots_filter_selected_bots');
        if (!original) {
            return;
        }

        // لو تم تهيئتها قبل كده لا نكررها
        if (original.classList.contains('bt-bots-multiselect-select-hidden')) {
            return;
        }

        var wrapper = document.createElement('div');
        wrapper.className = 'bt-bots-multiselect-wrapper';

        original.parentNode.insertBefore(wrapper, original);
        wrapper.appendChild(original);

        var button = document.createElement('button');
        button.type = 'button';
        button.className = 'button bt-bots-multiselect-toggle';
        button.setAttribute('aria-haspopup', 'listbox');
        button.setAttribute('aria-expanded', 'false');
        wrapper.insertBefore(button, original);

        var menu = document.createElement('div');
        menu.className = 'bt-bots-multiselect-menu';
        var list = document.createElement('ul');
        menu.appendChild(list);
        wrapper.appendChild(menu);

        original.classList.add('bt-bots-multiselect-select-hidden');

        multiSelectState.original  = original;
        multiSelectState.button    = button;

        var options = original.options;
        var i;

        for (i = 0; i < options.length; i++) {
            (function (option) {
                var li    = document.createElement('li');
                var label = document.createElement('label');
                label.className = 'bt-bots-multiselect-item';

                var checkbox = document.createElement('input');
                checkbox.type    = 'checkbox';
                checkbox.value   = option.value;
                checkbox.checked = option.selected;

                var span = document.createElement('span');
                span.textContent = option.text;

                label.appendChild(checkbox);
                label.appendChild(span);
                li.appendChild(label);
                list.appendChild(li);

                checkbox.addEventListener('change', function () {
                    option.selected = checkbox.checked;
                    updateButtonLabel();
                });
            })(options[i]);
        }

        button.addEventListener('click', function (e) {
            e.stopPropagation();
            var isOpen = menu.classList.toggle('is-open');
            button.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
        });

        document.addEventListener('click', function () {
            if (menu.classList.contains('is-open')) {
                menu.classList.remove('is-open');
                button.setAttribute('aria-expanded', 'false');
            }
        });

        menu.addEventListener('click', function (e) {
            e.stopPropagation();
        });

        // حفظ الاختيار الأولي حسب الوضع الحالي
        var initialMode = getCurrentMode();
        modeSelections[ initialMode ] = getCurrentSelection();

        updateButtonLabel();
    }

    /**
     * ✅ صفحة Bot Visits (Main): إظهار/إخفاء حقول التاريخ في Custom range
     * (بدلاً من وضع <script> داخل PHP)
     */
    function initMainPageCustomDates() {
        var selectPeriod   = document.getElementById('bt_period_type');
        var customDatesDiv = document.getElementById('bt-main-custom-dates');

        if (!selectPeriod || !customDatesDiv) {
            return;
        }

        function toggleCustomDates() {
            if (selectPeriod.value === 'custom') {
                customDatesDiv.classList.remove('bt-is-hidden');
            } else {
                customDatesDiv.classList.add('bt-is-hidden');
            }
        }

        selectPeriod.addEventListener('change', toggleCustomDates);
        toggleCustomDates();
    }

    /**
     * ✅ صفحة Crawl Budget: إظهار/إخفاء الحقول (Custom dates / Custom rows / Export scope / Export custom dates)
     * (بدلاً من وضع <script> داخل PHP)
     */
    function initCrawlBudgetPageToggles() {

        // فلتر الفترة للتقرير
        var selectPeriod   = document.getElementById('bt_period_type');
        var customDatesDiv = document.getElementById('bt-custom-dates');

        if (selectPeriod && customDatesDiv) {
            function toggleCustomDates() {
                if (selectPeriod.value === 'custom') {
                    customDatesDiv.classList.remove('bt-is-hidden');
                } else {
                    customDatesDiv.classList.add('bt-is-hidden');
                }
            }
            selectPeriod.addEventListener('change', toggleCustomDates);
            toggleCustomDates();
        }

        // فلتر الصفوف (custom rows)
        var selectPerPage = document.getElementById('bt_per_page_type');
        var perPageWrap   = document.getElementById('bt-per-page-custom-wrap');

        if (selectPerPage && perPageWrap) {
            function togglePerPageCustom() {
                if (selectPerPage.value === 'custom') {
                    perPageWrap.classList.remove('bt-is-hidden');
                } else {
                    perPageWrap.classList.add('bt-is-hidden');
                }
            }
            selectPerPage.addEventListener('change', togglePerPageCustom);
            togglePerPageCustom();
        }

        // Export: All Bots / Specific Bot
        var exportRadios = document.querySelectorAll('input[name="bt_export_scope"]');
        var exportBotSel = document.getElementById('bt_export_bot_name');

        function toggleExportBotSelect() {
            if (!exportBotSel || !exportRadios || !exportRadios.length) {
                return;
            }

            var scope = 'all';
            for (var i = 0; i < exportRadios.length; i++) {
                if (exportRadios[i].checked) {
                    scope = exportRadios[i].value;
                    break;
                }
            }

            if (scope === 'bot') {
                exportBotSel.disabled = false;
            } else {
                exportBotSel.disabled = true;
                exportBotSel.value = '';
            }
        }

        if (exportRadios && exportRadios.length && exportBotSel) {
            for (var r = 0; r < exportRadios.length; r++) {
                exportRadios[r].addEventListener('change', toggleExportBotSelect);
            }
            toggleExportBotSelect();
        }

        // فلتر الفترة لقسم التصدير CSV
        var exportPeriod   = document.getElementById('bt_export_period_type');
        var exportDatesDiv = document.getElementById('bt-export-custom-dates');

        if (exportPeriod && exportDatesDiv) {
            function toggleExportCustomDates() {
                if (exportPeriod.value === 'custom') {
                    exportDatesDiv.classList.remove('bt-is-hidden');
                } else {
                    exportDatesDiv.classList.add('bt-is-hidden');
                }
            }
            exportPeriod.addEventListener('change', toggleExportCustomDates);
            toggleExportCustomDates();
        }
    }

    /**
     * تهيئة كل شيء عند تحميل الصفحة
     */
    document.addEventListener('DOMContentLoaded', function () {

        /* 1) تلوين رسائل النجاح */
        var notices = document.querySelectorAll('.bt-bots-notice');
        if (notices.length) {
            notices.forEach(function (notice) {
                notice.style.transition = 'background-color 0.6s ease';
                setTimeout(function () {
                    notice.style.backgroundColor = '#f6fff0';
                }, 100);
            });
        }

        /* 2) تأكيد قبل حذف السجلات القديمة أو تفريغ الجدول */
        var deleteOldBtn = document.getElementById('bt-bots-delete-old-submit');
        if (deleteOldBtn) {
            deleteOldBtn.addEventListener('click', function (e) {
                var msg = deleteOldBtn.getAttribute('data-confirm') ||
                    'Are you sure you want to delete old records?';
                if (!window.confirm(msg)) {
                    e.preventDefault();
                }
            });
        }

        var clearAllBtn = document.getElementById('bt-bots-clear-all-submit');
        if (clearAllBtn) {
            clearAllBtn.addEventListener('click', function (e) {
                var msg = clearAllBtn.getAttribute('data-confirm') ||
                    'Are you absolutely sure you want to clear all bot visits?';
                if (!window.confirm(msg)) {
                    e.preventDefault();
                }
            });
        }

        /* 3) تفعيل منطق الفلتر + الملتسيلكت للبوتات */
        var enabledCheckbox  = document.getElementById('bt_bots_filter_enabled');
        var sourceRadios     = document.querySelectorAll('input[name="bt_bots_filter_source"]');
        var filterModeSelect = document.getElementById('bt_bots_filter_mode');

        if (enabledCheckbox) {
            enabledCheckbox.addEventListener('change', refreshBotFilterVisibility);
        }

        if (sourceRadios && sourceRadios.length) {
            for (var i = 0; i < sourceRadios.length; i++) {
                sourceRadios[i].addEventListener('change', refreshBotFilterVisibility);
            }
        }

        if (filterModeSelect) {
            filterModeSelect.addEventListener('change', function () {
                var previousMode = (filterModeSelect.value === 'include') ? 'exclude' : 'include';
                // خزّن اختيار الوضع السابق
                modeSelections[ previousMode ] = getCurrentSelection();
                // عدّل إلى الوضع الحالي
                var currentMode = getCurrentMode();
                var targetSelection = modeSelections[ currentMode ] || [];
                setSelection(targetSelection);
            });
        }

        refreshBotFilterVisibility();
        initBotMultiSelect();

        /* ✅ 4) منطق صفحة Main الخاصة بالـ Custom dates */
        initMainPageCustomDates();

        /* ✅ 5) منطق صفحة Crawl Budget */
        initCrawlBudgetPageToggles();
    });

})();
