<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * كلاس مسؤول عن إنشاء منيو الإضافة في لوحة التحكم
 * ويربط صفحات (Main, Crawl, Setting) تحت منيو واحدة.
 */
class BT_Bots_Tracker_Admin_Menu {

    /**
     * @var BT_Bots_Tracker_Page_Main
     */
    protected $page_main;

    /**
     * @var BT_Bots_Tracker_Page_Crawl
     */
    protected $page_crawl;

    /**
     * @var BT_Bots_Tracker_Page_Setting
     */
    protected $page_setting;

    /**
     * Constructor
     *
     * @param BT_Bots_Tracker_Page_Main    $page_main
     * @param BT_Bots_Tracker_Page_Crawl   $page_crawl
     * @param BT_Bots_Tracker_Page_Setting $page_setting
     */
    public function __construct( $page_main, $page_crawl, $page_setting ) {
        $this->page_main    = $page_main;
        $this->page_crawl   = $page_crawl;
        $this->page_setting = $page_setting;
    }

    /**
     * ربط منيو الإضافة بهوك admin_menu
     */
    public function init_menu() {
        add_action( 'admin_menu', array( $this, 'register_menu' ) );
    }

    /**
     * إنشاء المنيو والـ submenus
     */
    public function register_menu() {
        // الصفحة الرئيسية – تظهر كمنيو رئيسية
        add_menu_page(
            __( 'Bots Tracker', 'azayem-bots-tracker' ),          // Page title
            __( 'Bots Tracker', 'azayem-bots-tracker' ),          // Menu title
            'manage_options',                              // Capability
            'bt-bots-tracker',                             // Menu slug
            array( $this->page_main, 'render' ),           // Callback
            'dashicons-visibility',                        // Icon
            65                                             // Position
        );

        // صفحة عرض الزيارات (نفس الرئيسية – كـ Submenu أولى)
        add_submenu_page(
            'bt-bots-tracker',
            __( 'Bot visits', 'azayem-bots-tracker' ),
            __( 'Bot visits', 'azayem-bots-tracker' ),
            'manage_options',
            'bt-bots-tracker',
            array( $this->page_main, 'render' )
        );

        // صفحة ميزانية الزحف حسب الروابط
        add_submenu_page(
            'bt-bots-tracker',
            __( 'Crawl Budget', 'azayem-bots-tracker' ),
            __( 'Crawl budget', 'azayem-bots-tracker' ),
            'manage_options',
            'bt-bots-crawl-budget',
            array( $this->page_crawl, 'render' )
        );

        // صفحة الإعدادات (مدة الاحتفاظ بالبيانات)
        add_submenu_page(
            'bt-bots-tracker',
            __( 'Setting', 'azayem-bots-tracker' ),                         // Page title
            __( 'Setting', 'azayem-bots-tracker' ),                         // Menu title
            'manage_options',
            BT_Bots_Tracker_Page_Setting::PAGE_SLUG,                  // Menu slug
            array( $this->page_setting, 'render' )                    // Callback
        );
    }
}
