<?php
/**
 * Plugin Name: Azayem Bots Tracker – Bot Visits Logger
 * Description: Track real search engine bot visits in real time and analyze their crawl budget directly from your WordPress dashboard — without any external services.
 * Version: 1.0.0
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Author: Omar Abul-Azayem
 * Text Domain: azayem-bots-tracker
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * تعريف ثوابت الإضافة
 */
define( 'BT_BOTS_TRACKER_VERSION', '1.0.0' );
define( 'BT_BOTS_TRACKER_PATH', plugin_dir_path( __FILE__ ) );
define( 'BT_BOTS_TRACKER_URL', plugin_dir_url( __FILE__ ) );

// إصدار بنية قاعدة البيانات (يُستخدم في نظام الـ Migration)
// حاليًا لا يوجد اختلاف في هيكلة الجدول بين الإصدارات، لذلك 1.0.0
define( 'BT_BOTS_TRACKER_DB_VERSION', '1.0.0' );

/**
 * تحميل ملف اللودر المسؤول عن تهيئة الإضافة
 */
require_once BT_BOTS_TRACKER_PATH . 'includes/class-bt-loader.php';

/**
 * تفعيل الإضافة — إنشاء جدول وإعداد الإعدادات الأولية
 */
register_activation_hook(
    __FILE__,
    array( 'BT_Bots_Tracker_Loader', 'activate' )
);

/**
 * إلغاء تفعيل الإضافة (لا نقوم بحذف البيانات هنا)
 */
register_deactivation_hook(
    __FILE__,
    array( 'BT_Bots_Tracker_Loader', 'deactivate' )
);

/**
 * بدء تحميل الإضافة بعد تحميل جميع الإضافات
 */
add_action(
    'plugins_loaded',
    array( 'BT_Bots_Tracker_Loader', 'init' )
);

/**
 * 🔐 إضافة سياسة الخصوصية داخل صفحة Privacy Policy في ووردبريس
 */
function bt_bots_tracker_add_privacy_policy_content() {

    if ( ! function_exists( 'wp_add_privacy_policy_content' ) ) {
        return;
    }

    $content  = '<p>' . __( 'This plugin logs visits from search engine bots only. The following data is stored for each bot visit:', 'azayem-bots-tracker' ) . '</p>';
    $content .= '<ul>';
    $content .= '<li>' . __( 'Bot name (derived from the User-Agent string)', 'azayem-bots-tracker' ) . '</li>';
    $content .= '<li>' . __( 'Bot user agent', 'azayem-bots-tracker' ) . '</li>';
    $content .= '<li>' . __( 'Bot IP address', 'azayem-bots-tracker' ) . '</li>';
    $content .= '<li>' . __( 'Visited URL path', 'azayem-bots-tracker' ) . '</li>';
    $content .= '<li>' . __( 'Visit timestamp', 'azayem-bots-tracker' ) . '</li>';
    $content .= '</ul>';
    $content .= '<p>' . __( 'No data is sent to any third-party servers. This plugin tracks bots only, not human visitors.', 'azayem-bots-tracker' ) . '</p>';

    wp_add_privacy_policy_content(
        'Azayem Bots Tracker – Bot Visits Logger',
        wp_kses_post( $content )
    );
}
add_action( 'admin_init', 'bt_bots_tracker_add_privacy_policy_content' );
