<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package AYR_SEO_Bridge
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * Limpiar datos del plugin al desinstalar
 */

// Eliminar transients de rate limiting
global $wpdb;

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( 
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        '_transient_ayr_seo_rate_limit_%'
    )
);

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( 
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        '_transient_timeout_ayr_seo_rate_limit_%'
    )
);

// Limpiar cualquier configuración si la tuviéramos en el futuro
delete_option( 'ayr_seo_bridge_settings' );
delete_option( 'ayr_seo_bridge_version' );