# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).


## [1.0.1] - 2025-10-15

### Changed
- Improved rate limiting: Changed from 1 minute to 5 seconds between requests for better performance
- Enhanced user experience with faster API response times


## [1.0.0] - 2025-10-12

### Added
- Initial release of AYR SEO Bridge
- REST API endpoint for updating SEO metadata (`/wp-json/ayrseo/v1/update`)
- Legacy endpoint for backward compatibility (`/wp-json/custom/v1/update-yoast-meta`)
- Support for Yoast SEO plugin
- Support for Rank Math SEO plugin
- Support for All in One SEO (AIOSEO) plugin
- Support for SEOPress plugin
- Secure authentication using WordPress Application Passwords
- Rate limiting protection (1 request per minute per user)
- Comprehensive input validation and sanitization
- Detailed error handling and logging
- Full internationalization support
- WordPress coding standards compliance
- Automatic plugin version checking
- PHP and WordPress version compatibility checks

### Security
- Input sanitization for all user data
- Authorization checks for post editing permissions
- Rate limiting to prevent abuse
- Secure database queries using prepared statements
- Protection against direct file access

### Documentation
- Complete plugin documentation in readme.txt
- API usage examples and documentation
- Translation template (.pot file)
- Comprehensive inline code documentation

## [Unreleased]

### Planned
- Bulk update functionality
- Custom post type support
- Additional SEO plugin support
- Advanced rate limiting options
- Admin dashboard interface
- Webhook support for real-time updates