<?php
/**
 * Awesome Delivery Scheduler - Settings Page
 * Full Code: Indigo UI + Labels Card + Repeaters
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// 1. Initialize Variables
$awdts_settings = get_option( 'awdts_settings', array() );
$awdts_days     = array( 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday' );
$awdts_slots    = $awdts_settings['slots'] ?? array();
$awdts_holidays = $awdts_settings['holiday_list'] ?? array();

// 2. Save Logic
if ( isset( $_POST['awdts_save_slots'] ) && check_admin_referer( 'awdts_save_slot_settings' ) ) {
    $awdts_new_s = array();
    
    // Sanitize Labels (The missing fields)
    $awdts_new_s['checkout_date_label'] = sanitize_text_field( wp_unslash( $_POST['checkout_date_label'] ?? 'Delivery Date' ) );
    $awdts_new_s['checkout_time_label'] = sanitize_text_field( wp_unslash( $_POST['checkout_time_label'] ?? 'Delivery Time' ) );
    
    // Sanitize Rules
    $awdts_new_s['min_delivery_days']   = absint( $_POST['min_delivery_days'] ?? 0 );
    $awdts_new_s['max_delivery_days']   = absint( $_POST['max_delivery_days'] ?? 30 );
    $awdts_new_s['blocked_days']        = isset( $_POST['blocked_days'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['blocked_days'] ) ) : array();

    // Sanitize Time Slots
    $awdts_new_s['slots'] = array();
    if ( isset( $_POST['slots'] ) && is_array( $_POST['slots'] ) ) {
        foreach ( wp_unslash( $_POST['slots'] ) as $slot ) {
            if ( ! empty( $slot['day'] ) ) {
                $awdts_new_s['slots'][] = array(
                    'day'        => sanitize_text_field( $slot['day'] ),
                    'start_time' => sanitize_text_field( $slot['start_time'] ),
                    'end_time'   => sanitize_text_field( $slot['end_time'] ),
                );
            }
        }
    }

    // Sanitize Holidays
    $awdts_new_s['holiday_list'] = array();
    if ( isset( $_POST['holiday_list'] ) && is_array( $_POST['holiday_list'] ) ) {
        foreach ( wp_unslash( $_POST['holiday_list'] ) as $h_item ) {
            if ( ! empty( $h_item['date'] ) ) {
                $awdts_new_s['holiday_list'][] = array(
                    'date' => sanitize_text_field( $h_item['date'] ),
                    'name' => sanitize_text_field( $h_item['name'] ),
                );
            }
        }
    }

    update_option( 'awdts_settings', $awdts_new_s );
    $awdts_settings = $awdts_new_s;
    $awdts_slots = $awdts_settings['slots'];
    $awdts_holidays = $awdts_settings['holiday_list'];
    echo '<div class="awdts-toast"><span class="dashicons dashicons-saved"></span> Saved Successfully!</div>';
}

// Enqueue WP Assets
wp_enqueue_script( 'jquery-ui-datepicker' );
wp_enqueue_style( 'wp-jquery-ui-dialog' ); 
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.18/jquery.timepicker.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.18/jquery.timepicker.min.js"></script>

<style>
    .awdts-admin-wrap { max-width: 1100px; margin-top: 20px; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; }
    .awdts-header-bar { display: flex; justify-content: space-between; align-items: center; background: #fff; padding: 20px 25px; border-radius: 16px; border: 1px solid #e2e8f0; margin-bottom: 25px; }
    .awdts-header-bar h1 { margin:0; font-size: 22px; font-weight: 800; color: #1e293b; }
    .awdts-header-bar h1 span { color: #6366f1; }
    
    .awdts-main-grid { display: grid; grid-template-columns: 1fr 380px; gap: 25px; }
    @media (max-width: 900px) { .awdts-main-grid { grid-template-columns: 1fr; } }

    .awdts-card { background: #fff; border: 1px solid #e2e8f0; border-radius: 16px; padding: 25px; margin-bottom: 25px; }
    .awdts-card-title { display: flex; align-items: center; gap: 10px; font-size: 16px; font-weight: 700; color: #334155; margin-bottom: 20px; border-bottom: 1px solid #f1f5f9; padding-bottom: 12px; }
    .awdts-card-title .dashicons { color: #6366f1; }

    .awdts-form-group label { display: block; font-weight: 700; font-size: 11px; color: #94a3b8; text-transform: uppercase; margin-bottom: 6px; }
    .awdts-form-group input, .awdts-form-group select { width: 100%; border-radius: 10px; border: 1px solid #e2e8f0; padding: 10px 14px; background: #f8fafc; font-size: 14px; }
    
    .awdts-row { background: #f8fafc; border-radius: 12px; padding: 15px; display: grid; grid-template-columns: 1.2fr 1fr 1fr 40px; gap: 12px; margin-bottom: 10px; border: 1px solid #f1f5f9; align-items: end; }
    .awdts-holiday-row { grid-template-columns: 1.2fr 1.8fr 40px; }
    
    .awdts-remove { color: #f87171; cursor: pointer; text-align: center; height: 38px; display: flex; align-items: center; justify-content: center; transition: 0.2s; }
    .awdts-remove:hover { color: #ef4444; }

    .awdts-add-btn { background: #fff; color: #6366f1; border: 1px dashed #6366f1; width: 100%; padding: 12px; border-radius: 12px; font-weight: 600; cursor: pointer; }
    .awdts-save-btn { background: #6366f1; color: #fff; border: none; padding: 12px 30px; border-radius: 12px; font-weight: 700; cursor: pointer; }

    .awdts-pills { display: flex; flex-wrap: wrap; gap: 8px; }
    .awdts-pill { cursor: pointer; padding: 8px 14px; background: #f1f5f9; border-radius: 20px; font-size: 12px; font-weight: 600; color: #475569; }
    .awdts-pill input { display: none; }
    .awdts-pill.active { background: #6366f1; color: #fff; }

    .awdts-toast { position: fixed; top: 30px; right: 30px; background: #10b981; color: #fff; padding: 15px 25px; border-radius: 12px; z-index: 10000; box-shadow: 0 10px 15px rgba(0,0,0,0.1); }
</style>

<div class="awdts-admin-wrap">
    <form method="post">
        <?php wp_nonce_field( 'awdts_save_slot_settings' ); ?>

        <div class="awdts-header-bar">
            <h1><span>Awesome</span> Delivery Scheduler</h1>
            <button type="submit" name="awdts_save_slots" class="awdts-save-btn">Save Configuration</button>
        </div>

        <div class="awdts-main-grid">
            <div class="awdts-left">
                <div class="awdts-card">
                    <div class="awdts-card-title"><span class="dashicons dashicons-clock"></span> Weekly Delivery Slots</div>
                    <div id="awdts-slots-list">
                        <?php foreach ( $awdts_slots as $i => $slot ) : ?>
                            <div class="awdts-row">
                                <div class="awdts-form-group"><label>Day</label>
                                    <select name="slots[<?php echo $i; ?>][day]">
                                        <?php foreach($awdts_days as $d) echo "<option value='$d' ".selected($slot['day'], $d, false).">$d</option>"; ?>
                                    </select>
                                </div>
                                <div class="awdts-form-group"><label>Start</label>
                                    <input type="text" class="awdts-timepicker" name="slots[<?php echo $i; ?>][start_time]" value="<?php echo esc_attr($slot['start_time']); ?>">
                                </div>
                                <div class="awdts-form-group"><label>End</label>
                                    <input type="text" class="awdts-timepicker" name="slots[<?php echo $i; ?>][end_time]" value="<?php echo esc_attr($slot['end_time']); ?>">
                                </div>
                                <div class="awdts-remove"><span class="dashicons dashicons-trash"></span></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" id="add-slot" class="awdts-add-btn">+ Add Time Slot</button>
                </div>

                <div class="awdts-card">
                    <div class="awdts-card-title"><span class="dashicons dashicons-calendar-alt"></span> Holiday Blackout Dates</div>
                    <div id="awdts-holiday-list">
                        <?php foreach ( $awdts_holidays as $i => $h ) : ?>
                            <div class="awdts-row awdts-holiday-row">
                                <div class="awdts-form-group"><label>Date</label>
                                    <input type="text" class="awdts-datepicker" name="holiday_list[<?php echo $i; ?>][date]" value="<?php echo esc_attr($h['date']); ?>" readonly>
                                </div>
                                <div class="awdts-form-group"><label>Holiday Name</label>
                                    <input type="text" name="holiday_list[<?php echo $i; ?>][name]" value="<?php echo esc_attr($h['name']); ?>">
                                </div>
                                <div class="awdts-remove"><span class="dashicons dashicons-trash"></span></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" id="add-holiday" class="awdts-add-btn">+ Add Holiday Date</button>
                </div>
            </div>

            <div class="awdts-right">
                <div class="awdts-card">
                    <div class="awdts-card-title"><span class="dashicons dashicons-admin-settings"></span> Lead Time</div>
                    <div class="awdts-form-group"><label>Min Prep Days</label>
                        <input type="number" name="min_delivery_days" min="0" value="<?php echo esc_attr($awdts_settings['min_delivery_days'] ?? 0); ?>">
                    </div>
                    <div class="awdts-form-group" style="margin-top:15px;"><label>Max Future Days</label>
                        <input type="number" name="max_delivery_days" min="1" value="<?php echo esc_attr($awdts_settings['max_delivery_days'] ?? 30); ?>">
                    </div>
                </div>

                <div class="awdts-card">
                    <div class="awdts-card-title"><span class="dashicons dashicons-no"></span> Weekly Closures</div>
                    <div class="awdts-pills">
                        <?php foreach($awdts_days as $d): $c = in_array($d, $awdts_settings['blocked_days'] ?? []); ?>
                            <label class="awdts-pill <?php echo $c ? 'active' : ''; ?>">
                                <input type="checkbox" name="blocked_days[]" value="<?php echo $d; ?>" <?php checked($c); ?>> <?php echo $d; ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="awdts-card">
                    <div class="awdts-card-title"><span class="dashicons dashicons-editor-textcolor"></span> Labels</div>
                    <div class="awdts-form-group"><label>Date Field Label</label>
                        <input type="text" name="checkout_date_label" value="<?php echo esc_attr($awdts_settings['checkout_date_label'] ?? 'Delivery Date'); ?>">
                    </div>
                    <div class="awdts-form-group" style="margin-top:15px;"><label>Time Field Label</label>
                        <input type="text" name="checkout_time_label" value="<?php echo esc_attr($awdts_settings['checkout_time_label'] ?? 'Delivery Time'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
jQuery(document).ready(function($){
    function initPickers() {
        // Init Timepicker
        $('.awdts-timepicker').timepicker({ 'timeFormat': 'h:i A', 'step': 15, 'scrollDefault': 'now' });
        // Init Datepicker
        $('.awdts-datepicker').datepicker({ dateFormat: 'yy-mm-dd', minDate: 0 });
    }
    initPickers();

    $('#add-slot').on('click', function(){
        let i = $('#awdts-slots-list .awdts-row').length;
        let days = <?php echo wp_json_encode($awdts_days); ?>;
        let opts = ''; days.forEach(d => { opts += `<option value="${d}">${d}</option>`; });
        let html = `<div class="awdts-row" style="display:none;">
            <div class="awdts-form-group"><label>Day</label><select name="slots[${i}][day]">${opts}</select></div>
            <div class="awdts-form-group"><label>Start</label><input type="text" class="awdts-timepicker" name="slots[${i}][start_time]"></div>
            <div class="awdts-form-group"><label>End</label><input type="text" class="awdts-timepicker" name="slots[${i}][end_time]"></div>
            <div class="awdts-remove"><span class="dashicons dashicons-trash"></span></div>
        </div>`;
        $(html).appendTo('#awdts-slots-list').slideDown(200);
        initPickers();
    });

    $('#add-holiday').on('click', function(){
        let i = $('#awdts-holiday-list .awdts-row').length;
        let html = `<div class="awdts-row awdts-holiday-row" style="display:none;">
            <div class="awdts-form-group"><label>Date</label><input type="text" class="awdts-datepicker" name="holiday_list[${i}][date]" readonly></div>
            <div class="awdts-form-group"><label>Name</label><input type="text" name="holiday_list[${i}][name]"></div>
            <div class="awdts-remove"><span class="dashicons dashicons-trash"></span></div>
        </div>`;
        $(html).appendTo('#awdts-holiday-list').slideDown(200);
        initPickers();
    });

    $(document).on('click', '.awdts-remove', function(){
        $(this).closest('.awdts-row').fadeOut(200, function(){ $(this).remove(); });
    });

    $(document).on('change', '.awdts-pill input', function(){
        $(this).parent().toggleClass('active', this.checked);
    });

    setTimeout(() => { $('.awdts-toast').fadeOut(); }, 3000);
});
</script>