<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$settings = get_option( 'awesome-delivery-scheduler-for-woocommerce_settings', array() );
$orders   = wc_get_orders( array( 'limit' => -1, 'meta_key' => '_awesome-delivery-scheduler-for-woocommerce_delivery_date', 'meta_compare' => 'EXISTS' ) );

// Data Calculations
$total_deliveries = count( $orders );
$today            = gmdate( 'Y-m-d' );
$deliveries_today = 0;
$total_revenue    = 0;

foreach ( $orders as $o ) {
	if ( $o->get_meta( '_awesome-delivery-scheduler-for-woocommerce_delivery_date' ) === $today ) {
		$deliveries_today++;
	}
	if ( 'cancelled' !== $o->get_status() ) {
		$total_revenue += (float) $o->get_total();
	}
}
?>

<style>
    :root {
        --glass-bg: rgba(255, 255, 255, 0.7);
        --accent: #6366f1;
        --text-dark: #0f172a;
        --text-light: #64748b;
    }

    /* --- Stats Section --- */
    .awesome-delivery-scheduler-for-woocommerce-dashboard-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 24px; margin-bottom: 40px; }
    .awesome-delivery-scheduler-for-woocommerce-glass-card { 
        background: #fff; border: 1px solid #f1f5f9; padding: 24px; border-radius: 24px;
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.02), 0 2px 4px -2px rgba(0,0,0,0.02);
        transition: all 0.3s ease;
    }
    .awesome-delivery-scheduler-for-woocommerce-glass-card:hover { transform: translateY(-5px); box-shadow: 0 20px 25px -5px rgba(0,0,0,0.05); }

    /* --- Awesome Table Design --- */
    .awesome-delivery-scheduler-for-woocommerce-table-container { background: #fff; border-radius: 24px; border: 1px solid #f1f5f9; padding: 10px; }
    .awesome-delivery-scheduler-for-woocommerce-ultra-table { width: 100%; border-collapse: separate; border-spacing: 0 10px; }
    .awesome-delivery-scheduler-for-woocommerce-ultra-table thead th { 
        padding: 15px 20px; color: var(--text-light); font-size: 11px; text-transform: uppercase; 
        letter-spacing: 1px; font-weight: 700; border: none;
    }

    /* Row Styling */
    .awesome-delivery-scheduler-for-woocommerce-ultra-table tbody tr { transition: all 0.2s ease; cursor: default; }
    .awesome-delivery-scheduler-for-woocommerce-ultra-table tbody td { 
        background: #fff; padding: 18px 20px; border-top: 1px solid #f8fafc; border-bottom: 1px solid #f8fafc;
        font-size: 14px; color: var(--text-dark);
    }
    .awesome-delivery-scheduler-for-woocommerce-ultra-table tbody td:first-child { border-left: 1px solid #f8fafc; border-top-left-radius: 16px; border-bottom-left-radius: 16px; }
    .awesome-delivery-scheduler-for-woocommerce-ultra-table tbody td:last-child { border-right: 1px solid #f8fafc; border-top-right-radius: 16px; border-bottom-right-radius: 16px; }

    /* Row Hover Effect */
    .awesome-delivery-scheduler-for-woocommerce-ultra-table tbody tr:hover td { background: #fcfdfe; border-color: #e2e8f0; }

    /* --- Dynamic Status Pills --- */
    .status-pill { 
        display: inline-flex; align-items: center; gap: 6px; padding: 5px 12px; border-radius: 100px; 
        font-size: 11px; font-weight: 700; text-transform: uppercase;
    }
    .status-dot { width: 6px; height: 6px; border-radius: 50%; }
    
    .status-completed { background: #ecfdf5; color: #065f46; }
    .status-completed .status-dot { background: #10b981; box-shadow: 0 0 8px #10b981; }
    
    .status-processing { background: #eff6ff; color: #1e40af; }
    .status-processing .status-dot { background: #3b82f6; animation: pulse 2s infinite; }

    /* --- Typography & Elements --- */
    .order-id { font-family: 'Monaco', monospace; font-weight: 700; color: var(--accent); background: #f5f3ff; padding: 4px 8px; border-radius: 6px; }
    .customer-name { font-weight: 600; display: block; margin-bottom: 2px; }
    .customer-meta { font-size: 12px; color: var(--text-light); }
    
    .delivery-time-box { display: flex; align-items: center; gap: 10px; }
    .date-circle { width: 38px; height: 38px; border-radius: 10px; background: #f8fafc; display: flex; flex-direction: column; align-items: center; justify-content: center; font-size: 10px; line-height: 1; }
    .date-circle b { font-size: 14px; color: var(--accent); }

    .btn-action { 
        display: inline-flex; align-items: center; justify-content: center; width: 36px; height: 36px; 
        border-radius: 10px; background: #f1f5f9; color: #475569; text-decoration: none; transition: all 0.2s;
    }
    .btn-action:hover { background: var(--text-dark); color: #fff; }

    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.4; }
        100% { opacity: 1; }
    }
</style>

<div class="awesome-delivery-scheduler-for-woocommerce-report-view">
    
    <div class="awesome-delivery-scheduler-for-woocommerce-dashboard-grid">
        <div class="awesome-delivery-scheduler-for-woocommerce-glass-card">
            <span style="color:var(--text-light); font-size:12px; font-weight:700;"><?php esc_html_e( 'ACTIVE ORDERS', 'awesome-delivery-scheduler-for-woocommerce' ); ?></span>
            <div style="font-size:32px; font-weight:800; margin:10px 0;"><?php echo absint( $total_deliveries ); ?></div>
            <div style="color:#10b981; font-size:12px; font-weight:600;">↑ 12% from last month</div>
        </div>
        <div class="awesome-delivery-scheduler-for-woocommerce-glass-card" style="background: var(--accent); color: #fff;">
            <span style="opacity:0.8; font-size:12px; font-weight:700;"><?php esc_html_e( 'TODAY\'S DELIVERIES', 'awesome-delivery-scheduler-for-woocommerce' ); ?></span>
            <div style="font-size:32px; font-weight:800; margin:10px 0;"><?php echo absint( $deliveries_today ); ?></div>
            <div style="opacity:0.8; font-size:12px;"><?php esc_html_e( 'Deliveries scheduled for today', 'awesome-delivery-scheduler-for-woocommerce' ); ?></div>
        </div>
        <div class="awesome-delivery-scheduler-for-woocommerce-glass-card">
            <span style="color:var(--text-light); font-size:12px; font-weight:700;"><?php esc_html_e( 'GROSS REVENUE', 'awesome-delivery-scheduler-for-woocommerce' ); ?></span>
            <div style="font-size:32px; font-weight:800; margin:10px 0;"><?php echo wp_kses_post( wc_price( $total_revenue ) ); ?></div>
            <div style="width:100%; height:4px; background:#f1f5f9; border-radius:10px; margin-top:15px;">
                <div style="width:70%; height:100%; background:var(--accent); border-radius:10px;"></div>
            </div>
        </div>
    </div>

    <div class="awesome-delivery-scheduler-for-woocommerce-table-container">
        <table class="awesome-delivery-scheduler-for-woocommerce-ultra-table">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Order Info', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                    <th><?php esc_html_e( 'Customer', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                    <th><?php esc_html_e( 'Delivery Schedule', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                    <th><?php esc_html_e( 'Status', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                    <th><?php esc_html_e( 'Total', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                    <th style="text-align:right;"><?php esc_html_e( 'Action', 'awesome-delivery-scheduler-for-woocommerce' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php 
                foreach ( $orders as $order ) : 
                    $order_id = $order->get_id();
                    $date_raw = $order->get_meta( '_awesome-delivery-scheduler-for-woocommerce_delivery_date' );
                    $day      = gmdate( 'd', strtotime( $date_raw ) );
                    $month    = gmdate( 'M', strtotime( $date_raw ) );
                    $status   = $order->get_status();
                ?>
                <tr>
                    <td>
                        <span class="order-id">#<?php echo absint( $order_id ); ?></span>
                    </td>
                    <td>
                        <span class="customer-name"><?php echo esc_html( $order->get_formatted_billing_full_name() ); ?></span>
                        <span class="customer-meta"><?php echo esc_html( $order->get_billing_email() ); ?></span>
                    </td>
                    <td>
                        <div class="delivery-time-box">
                            <div class="date-circle">
                                <span><?php echo esc_html( $month ); ?></span>
                                <b><?php echo esc_html( $day ); ?></b>
                            </div>
                            <div>
                                <div style="font-weight:600;"><?php echo esc_html( $date_raw ); ?></div>
                                <div style="font-size:12px; color:var(--text-light);"><?php echo esc_html( $order->get_meta( '_awesome-delivery-scheduler-for-woocommerce_delivery_slot' ) ); ?></div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <span class="status-pill status-<?php echo esc_attr( $status ); ?>">
                            <span class="status-dot"></span>
                            <?php echo esc_html( wc_get_order_status_name( $status ) ); ?>
                        </span>
                    </td>
                    <td>
                        <div style="font-weight:800; color:var(--text-dark);"><?php echo wp_kses_post( wc_price( $order->get_total() ) ); ?></div>
                    </td>
                    <td style="text-align:right;">
                        <a href="<?php echo esc_url( get_edit_post_link( $order_id ) ); ?>" class="btn-action" title="<?php esc_attr_e( 'View Order', 'awesome-delivery-scheduler-for-woocommerce' ); ?>">
                            <span class="dashicons dashicons-external"></span>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>