<?php
if (!defined('ABSPATH')) exit;

$settings = get_option('awdts_settings', array());

// Save Settings
if (isset($_POST['awdts_save_general']) && check_admin_referer('awdts_save_general_settings')) {
    $settings['enabled'] = isset($_POST['enabled']) ? 'yes' : 'no';
    update_option('awdts_settings', $settings);
    echo '<div class="awdts-alert success">
            <span class="dashicons dashicons-yes-alt"></span> 
            General settings saved successfully.
          </div>';
}
?>

<style>
    /* Premium Toggle Switch */
    .awdts-switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 26px;
    }

    .awdts-switch input { opacity: 0; width: 0; height: 0; }

    .awdts-slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #e2e8f0;
        transition: .4s;
        border-radius: 34px;
    }

    .awdts-slider:before {
        position: absolute;
        content: "";
        height: 18px; width: 18px;
        left: 4px; bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    input:checked + .awdts-slider { background-color: #6366f1; }
    input:focus + .awdts-slider { box-shadow: 0 0 1px #6366f1; }
    input:checked + .awdts-slider:before { transform: translateX(24px); }

    /* Component Styling */
    .awdts-settings-title {
        font-size: 22px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .awdts-settings-title .dashicons { color: #6366f1; font-size: 24px; width: 24px; height: 24px; }

    .awdts-form-row {
        display: flex;
        align-items: flex-start;
        padding: 25px 0;
        border-bottom: 1px solid #f1f5f9;
    }

    .awdts-form-label { width: 300px; padding-right: 20px; }
    .awdts-form-label strong { display: block; font-size: 15px; color: #334155; margin-bottom: 4px; }
    .awdts-form-label p { font-size: 13px; color: #64748b; margin: 0; line-height: 1.5; }

    .awdts-btn-save {
        background: #0f172a !important;
        color: #fff !important;
        border: none !important;
        padding: 12px 30px !important;
        font-size: 14px !important;
        font-weight: 600 !important;
        border-radius: 12px !important;
        cursor: pointer;
        transition: all 0.2s ease;
        margin-top: 30px;
        height: auto !important;
    }

    .awdts-btn-save:hover { background: #1e293b !important; transform: translateY(-1px); box-shadow: 0 4px 12px rgba(0,0,0,0.1); }

    .awdts-alert {
        padding: 15px 20px;
        border-radius: 12px;
        margin-bottom: 25px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .awdts-alert.success { background: #ecfdf5; color: #065f46; border: 1px solid #a7f3d0; }
</style>

<div class="awdts-general-view">
    <h2 class="awdts-settings-title">
        <span class="dashicons dashicons-admin-generic"></span> 
        General Configuration
    </h2>

    <form method="post">
        <?php wp_nonce_field('awdts_save_general_settings'); ?>

        <div class="awdts-form-row">
            <div class="awdts-form-label">
                <strong>Enable Delivery Module</strong>
                <p>Activate or deactivate the date and time picker on your checkout page.</p>
            </div>
            <div class="awdts-form-control">
                <label class="awdts-switch">
                    <input type="checkbox" name="enabled" id="enabled" value="yes" <?php checked($settings['enabled'] ?? '', 'yes'); ?>>
                    <span class="awdts-slider"></span>
                </label>
            </div>
        </div>

        <div class="awdts-actions">
            <input type="submit" name="awdts_save_general" class="awdts-btn-save" value="Save Changes">
        </div>
    </form>
</div>