<?php
/**
 * Plugin Name: Awesome Delivery Scheduler for WooCommerce
 * Plugin URI:  https://devnahian.com/plugins/awesome-delivery-scheduler
 * Description: Add delivery date & time slot fields to WooCommerce checkout with blocked dates and weekdays.
 * Version:     1.2
 * Author:      Abdullah Nahian
 * Author URI:  https://devnahian.com
 * Text Domain: awesome-delivery-scheduler-for-woocommerce
 * Domain Path: /languages
 * Requires at least: 6.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) exit;

// --------------------
// Include Admin & Frontend
// --------------------
require_once plugin_dir_path(__FILE__) . 'admin.php';
require_once plugin_dir_path(__FILE__) . 'frontend.php';

// --------------------
// Enqueue All Assets
// --------------------

// Admin Assets
add_action('admin_enqueue_scripts', function($hook){
    if(strpos($hook,'awdts-settings') === false) return;

    // CSS
    wp_enqueue_style('timepicker', plugin_dir_url(__FILE__) . 'assets/css/timepicker.min.css', [], '1.0');
    wp_enqueue_style('datatables', plugin_dir_url(__FILE__) . 'assets/css/dataTables.min.css', [], '1.0');
    wp_enqueue_style('jquery-ui', plugin_dir_url(__FILE__) . 'assets/css/jquery-ui.css', [], '1.0');
    wp_enqueue_style('awdts-admin', plugin_dir_url(__FILE__) . 'assets/css/admin.css', [], '1.0');

    // JS
    wp_enqueue_script('jquery-ui-datepicker'); // WP core jQuery UI
    wp_enqueue_script('timepicker', plugin_dir_url(__FILE__) . 'assets/js/timepicker.min.js', ['jquery'], '1.0', true);
    wp_enqueue_script('datatables', plugin_dir_url(__FILE__) . 'assets/js/dataTables.min.js', ['jquery'], '1.0', true);
    wp_enqueue_script('awdts-admin-js', plugin_dir_url(__FILE__) . 'assets/js/admin.js', ['jquery'], '1.0', true);
});

// Frontend Assets
add_action('wp_enqueue_scripts', function(){
    if(!is_checkout()) return;

    // CSS
    wp_enqueue_style('awdts-frontend-css', plugin_dir_url(__FILE__) . 'assets/css/frontend.css', [], '1.0');
    wp_enqueue_style('jquery-ui-css', false, ['jquery-ui-core','jquery-ui-datepicker'], '1.13.2'); // Use WP core

    // JS
    wp_enqueue_script('jquery-ui-datepicker'); // WP core
    wp_enqueue_script('awdts-frontend-js', plugin_dir_url(__FILE__) . 'assets/js/frontend.js', ['jquery','jquery-ui-datepicker'], '1.0', true);

    // Pass settings to frontend.js
    $settings = get_option('awdts_settings', []);
    wp_localize_script('awdts-frontend-js', 'awdts_params', $settings);
});

/**
 * Show Delivery Details in Admin Order Edit Page
 */
add_action('add_meta_boxes', function() {
    add_meta_box(
        'awdts_delivery_details',
        'Delivery Schedule',
        function($post) {
            $order = wc_get_order($post->ID);
            $date = $order->get_meta('_awdts_delivery_date');
            $time = $order->get_meta('_awdts_delivery_slot');

            if ($date) {
                echo '<p><strong>Date:</strong> ' . esc_html($date) . '</p>';
                echo '<p><strong>Time Slot:</strong> ' . esc_html($time) . '</p>';
            } else {
                echo '<p>No delivery schedule selected.</p>';
            }
        },
        'shop_order',
        'side',
        'default'
    );
});

/**
 * Display Delivery Details on Order Received page and Emails
 */
add_action('woocommerce_order_details_after_order_table', 'awdts_display_delivery_on_receipt', 10, 1);
add_action('woocommerce_email_after_order_table', 'awdts_display_delivery_on_receipt', 10, 1);

function awdts_display_delivery_on_receipt($order) {
    $date = $order->get_meta('_awdts_delivery_date');
    $time = $order->get_meta('_awdts_delivery_slot');

    if (!$date) return;

    echo '<div style="margin-bottom: 20px; padding: 15px; border: 1px solid #e2e8f0; border-radius: 8px; background: #f8fafc;">';
    echo '<h2 style="margin: 0 0 10px 0; font-size: 18px; color: #6366f1;">Delivery Schedule</h2>';
    echo '<p style="margin:0;"><strong>Date:</strong> ' . esc_html($date) . '</p>';
    echo '<p style="margin:0;"><strong>Time:</strong> ' . esc_html($time) . '</p>';
    echo '</div>';
}