<?php
if(!defined('ABSPATH')) exit;

/**
 * 1. WooCommerce Dependency & Menu Registration
 */
add_action('admin_menu', function(){
    // Check if WooCommerce is active
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function() {
            echo '<div class="error"><p><strong>Delivery Scheduler</strong> requires WooCommerce to be installed.</p></div>';
        });
        return;
    }

    add_menu_page(
        'Delivery Scheduler', 
        'Delivery Scheduler', 
        'manage_options',     
        'awdts-settings',     
        'awdts_render_admin_page', 
        'dashicons-clock',     
        55                    
    );
});

/**
 * 2. Integrated Awesome Design (No external file needed)
 */
add_action('admin_head', function() {
    $screen = get_current_screen();
    if ( !isset($screen->id) || strpos($screen->id, 'awdts-settings') === false ) return;
    ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@500;600;700;800&display=swap');

        /* Clean WP UI */
        #wpcontent { padding-left: 0 !important; background: #f4f7fa; }
        #wpfooter, .update-nag, .notice { display: none !important; }

        /* Floating Layout */
        .awdts-app-frame {
            display: flex;
            padding: 25px 25px 25px 15px; /* Left-side spacing */
            gap: 25px;
            min-height: calc(100vh - 32px);
            font-family: 'Plus Jakarta Sans', sans-serif;
            box-sizing: border-box;
        }

        /* Awesome Sidebar */
        .awdts-sidebar {
            width: 280px;
            background: #0f172a; /* Deep Midnight */
            border-radius: 30px;
            padding: 40px 20px;
            display: flex;
            flex-direction: column;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            position: sticky;
            top: 52px;
            height: calc(100vh - 82px);
        }

        .awdts-brand {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 0 10px 45px;
        }

        .awdts-logo {
            width: 44px; height: 44px;
            background: linear-gradient(135deg, #6366f1 0%, #a855f7 100%);
            border-radius: 14px;
            display: grid; place-items: center;
            color: white;
            box-shadow: 0 10px 20px rgba(99, 102, 241, 0.4);
        }

        .awdts-brand-text b { display: block; color: white; font-size: 18px; letter-spacing: -0.5px; }
        .awdts-brand-text span { font-size: 11px; color: #64748b; font-weight: 600; }

        /* Sidebar Nav */
        .awdts-nav { display: flex; flex-direction: column; gap: 8px; }
        .awdts-nav-item {
            display: flex; align-items: center; gap: 14px;
            padding: 14px 18px; border-radius: 16px;
            text-decoration: none; color: #94a3b8;
            font-weight: 600; font-size: 14px;
            transition: all 0.3s ease;
        }

        .awdts-nav-item:hover {
            background: rgba(255, 255, 255, 0.05);
            color: white;
            transform: translateX(5px);
        }

        .awdts-nav-item.is-active {
            background: #6366f1;
            color: white;
            box-shadow: 0 10px 20px -5px rgba(99, 102, 241, 0.5);
        }

        /* Main Area */
        .awdts-main { flex: 1; }
        .awdts-view-header h1 { 
            font-size: 32px; font-weight: 800; margin: 10px 0 25px; 
            color: #1e293b; letter-spacing: -1px; 
        }

        .awdts-content-canvas {
            background: #ffffff;
            border-radius: 30px;
            padding: 40px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.03);
            min-height: 550px;
            border: 1px solid rgba(0,0,0,0.02);
        }

        .awdts-status-footer {
            margin-top: auto;
            padding: 15px;
            background: rgba(255,255,255,0.03);
            border-radius: 20px;
            color: #64748b;
            font-size: 12px;
            display: flex; align-items: center; gap: 8px;
        }
        .dot { width: 8px; height: 8px; background: #10b981; border-radius: 50%; }
    </style>
    <?php
});

/**
 * 3. Render Admin Page (Same Logic)
 */
function awdts_render_admin_page(){
    $tabs = [
        'general'  => ['label' => 'General', 'icon' => 'dashicons-grid-view'],
        'settings' => ['label' => 'Settings', 'icon' => 'dashicons-admin-settings'],
        'reports'  => ['label' => 'Reports', 'icon' => 'dashicons-chart-area'],
    ];

    $current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'general';
    ?>

    <div class="awdts-app-frame">
        <aside class="awdts-sidebar">
            <div class="awdts-brand">
                <div class="awdts-logo"><span class="dashicons dashicons-clock"></span></div>
                <div class="awdts-brand-text">
                    <b>Scheduler</b>
                    <span>WooCommerce</span>
                </div>
            </div>

            <nav class="awdts-nav">
                <?php foreach($tabs as $slug => $data): 
                    $active = ($current_tab === $slug) ? 'is-active' : '';
                ?>
                    <a href="?page=awdts-settings&tab=<?php echo esc_attr($slug); ?>" class="awdts-nav-item <?php echo esc_attr($active); ?>">
                        <span class="dashicons <?php echo esc_attr($data['icon']); ?>"></span>
                        <span><?php echo esc_html($data['label']); ?></span>
                    </a>
                <?php endforeach; ?>
            </nav>

            <div class="awdts-status-footer">
                <span class="dot"></span> System Live
            </div>
        </aside>

        <main class="awdts-main">
            <header class="awdts-view-header">
                <h1><?php echo esc_html($tabs[$current_tab]['label']); ?></h1>
            </header>

            <div class="awdts-content-canvas">
                <?php
                // Standard Tab Include Logic
                $file_slug = ($current_tab === 'reports') ? 'report' : $current_tab;
                $tab_file = plugin_dir_path(__FILE__) . 'tab/' . $file_slug . '.php';

                if (file_exists($tab_file)) {
                    include $tab_file;
                } else {
                    echo '<p style="color:#94a3b8;">Welcome! Please select a tab above.</p>';
                }
                ?>
            </div>
        </main>
    </div>
    <?php
}