<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Class to handle interactions with the AutopilotSEO API
 */
class AutopilotSEO_API
{

    /**
     * Send a request to the AutopilotSEO API
     *
     * @param string $endpoint
     * @param array  $params
     * @return array|WP_Error
     */
    public static function request($endpoint, $params = [])
    {
        $response = wp_remote_post($endpoint, [
            'timeout' => 30,
            'body'    => $params,
        ]);

        if (is_wp_error($response)) {
            return $response;
        }

        $code = wp_remote_retrieve_response_code($response);
        $body = wp_remote_retrieve_body($response);

        if (200 === $code) {
            return json_decode($body, true);
        } else {
            return new WP_Error('autopilotseo_api_error', 'Error requesting remote API.');
        }
    }
}
