<?php

/**
 * Plugin Name:       AutopilotSEO Connector
 * Description:       Connects your WordPress site to the AutopilotSEO platform.
 * Version:           1.0.4
 * Author:            AutopilotSEO
 * Author URI:        https://autopilotseo.ai
 * Text Domain:       autopilotseo-connector
 * Requires at least: 5.6
 * Tested up to:      6.7
 * Requires PHP:      7.4
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// 1. Define plugin constants (e.g., version, slug, option names).
define('AUTOPILOTSEO_VERSION', '1.0.4');
define('AUTOPILOTSEO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AUTOPILOTSEO_PLUGIN_URL', plugin_dir_url(__FILE__));
define('AUTOPILOTSEO_TEXT_DOMAIN', 'autopilotseo-connector');

// 2. Load plugin files.
require_once AUTOPILOTSEO_PLUGIN_DIR . 'includes/autopilotseo_functions.php';
require_once AUTOPILOTSEO_PLUGIN_DIR . 'includes/autopilotseo_api.php';
require_once AUTOPILOTSEO_PLUGIN_DIR . 'includes/autopilotseo_rest.php';
require_once AUTOPILOTSEO_PLUGIN_DIR . 'includes/autopilotseo_html_to_gutenberg.php';
require_once AUTOPILOTSEO_PLUGIN_DIR . 'admin/autopilotseo_admin.php';
require_once AUTOPILOTSEO_PLUGIN_DIR . 'admin/autopilotseo_admin_menu.php';

// 3. Hook plugin initialization
function autopilotseo_init_plugin()
{
    // Instantiate classes
    new AutopilotSEO_Admin();
    new AutopilotSEO_Admin_Menu();
    new AutopilotSEO_REST();
    new AutopilotSEO_HTML_To_Gutenberg();
}
add_action('plugins_loaded', 'autopilotseo_init_plugin');

// 4. Activation and Deactivation Hooks
function autopilotseo_activate_plugin()
{
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'autopilotseo_activate_plugin');

function autopilotseo_deactivate_plugin()
{
    // Clean up rewrite rules or ephemeral data if necessary.
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'autopilotseo_deactivate_plugin');

// Add function to enqueue admin scripts and styles
function autopilotseo_enqueue_admin_assets($hook)
{
    // Only load on our plugin's settings page
    if ('settings_page_autopilotseo_settings' !== $hook) {
        return;
    }

    wp_enqueue_style(
        'autopilotseo-admin-styles',
        AUTOPILOTSEO_PLUGIN_URL . 'admin/css/autopilotseo_admin_settings.css',
        array(),
        AUTOPILOTSEO_VERSION
    );

    wp_enqueue_script(
        'autopilotseo-admin-script',
        AUTOPILOTSEO_PLUGIN_URL . 'admin/js/autopilotseo_admin_settings.js',
        array('jquery'),
        AUTOPILOTSEO_VERSION,
        true
    );
}
add_action('admin_enqueue_scripts', 'autopilotseo_enqueue_admin_assets');
