(function () {
    // Wait for DOM to be fully loaded
    document.addEventListener('DOMContentLoaded', function () {
        console.log('AutopilotSEO admin script loaded'); // Debug line

        // Toggle API key visibility.
        var toggleButton = document.getElementById('toggle_api_key');
        console.log('Toggle button:', toggleButton); // Debug line

        if (toggleButton) {
            toggleButton.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent any default button behavior
                console.log('Toggle button clicked'); // Debug line
                var apiKeyInput = document.getElementById('autopilotseo_api_key');
                if (apiKeyInput.type === 'password') {
                    apiKeyInput.type = 'text';
                    toggleButton.textContent = 'Hide';
                } else {
                    apiKeyInput.type = 'password';
                    toggleButton.textContent = 'Show';
                }
            });
        }

        // Modal functionality for Update
        var updateButton = document.getElementById('update_button');
        var updateModal = document.getElementById('update_modal');
        var modalContinue = document.getElementById('modal_continue');
        var modalCancel = document.getElementById('modal_cancel');
        var normalButtons = document.getElementById('normal_buttons');
        var editingButtons = document.getElementById('editing_buttons');
        var cancelButton = document.getElementById('cancel_button');

        console.log('Update button:', updateButton); // Debug line
        console.log('Modal:', updateModal); // Debug line

        if (updateButton) {
            updateButton.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent any default button behavior
                console.log('Update button clicked'); // Debug line
                // Show the modal confirmation dialog.
                if (updateModal) {
                    updateModal.style.display = 'block';
                    var overlay = updateModal.querySelector('.autopilotseo-modal-overlay');
                    var content = updateModal.querySelector('.autopilotseo-modal-content');
                    if (overlay) overlay.style.display = 'block';
                    if (content) content.style.display = 'block';
                }
            });
        }

        if (modalContinue) {
            modalContinue.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent any default button behavior
                // Unlock the input fields for editing.
                var apiKeyInput = document.getElementById('autopilotseo_api_key');
                var websiteInput = document.getElementById('autopilotseo_website_id');
                if (apiKeyInput) apiKeyInput.disabled = false;
                if (websiteInput) websiteInput.disabled = false;
                // Change API key field to text so it is viewable/editable.
                if (apiKeyInput) apiKeyInput.type = 'text';
                // Switch button sets
                if (normalButtons) normalButtons.style.display = 'none';
                if (editingButtons) editingButtons.style.display = 'block';
                // Hide the modal
                if (updateModal) {
                    updateModal.style.display = 'none';
                    var overlay = updateModal.querySelector('.autopilotseo-modal-overlay');
                    var content = updateModal.querySelector('.autopilotseo-modal-content');
                    if (overlay) overlay.style.display = 'none';
                    if (content) content.style.display = 'none';
                }
            });
        }

        if (modalCancel) {
            modalCancel.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent any default button behavior
                if (updateModal) {
                    updateModal.style.display = 'none';
                    var overlay = updateModal.querySelector('.autopilotseo-modal-overlay');
                    var content = updateModal.querySelector('.autopilotseo-modal-content');
                    if (overlay) overlay.style.display = 'none';
                    if (content) content.style.display = 'none';
                }
            });
        }

        if (cancelButton) {
            cancelButton.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent any default button behavior
                var apiKeyInput = document.getElementById('autopilotseo_api_key');
                var websiteInput = document.getElementById('autopilotseo_website_id');
                var origApiKey = document.getElementById('autopilotseo_original_api_key').value;
                var origWebsite = document.getElementById('autopilotseo_original_website_id').value;

                if (apiKeyInput) {
                    apiKeyInput.value = origApiKey;
                    apiKeyInput.disabled = true;
                    apiKeyInput.type = 'password';
                }
                if (websiteInput) {
                    websiteInput.value = origWebsite;
                    websiteInput.disabled = true;
                }

                if (editingButtons) editingButtons.style.display = 'none';
                if (normalButtons) normalButtons.style.display = 'block';

                if (toggleButton && origApiKey) {
                    toggleButton.textContent = 'Show';
                }
            });
        }
    });
})(); 