<?php
class ZIAI_Modules {
    public static function ziai_init() {
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ziai_load_admin_style' ) );
        add_action( 'admin_menu', array( __CLASS__, 'ziai_register_menu_page' ) );
        add_action('wp_ajax_ziai_category_get', array( __CLASS__, 'ziai_category_get' ));
        add_action('init', array( __CLASS__, 'ziai_register_post_type' ));
    }

    public static function ziai_register_menu_page() {
        add_submenu_page(
            'edit.php?post_type=zl_ziai_article',
            'Settings',
            'Settings',
            'manage_options',
            'ziai-articles',
            array( __CLASS__, 'ziai_admin_show_data' )
        );
    }

    public static function ziai_load_admin_style() {
        wp_enqueue_style( 'ziai_admin_style_css', ZIAI_FILE_URL . 'assets/css/style-admin.css');
        wp_enqueue_script('zl_admin_custom_script', ZIAI_FILE_URL . 'assets/js/zl-admin-custom.js', array('jquery'), '1.0', true);
        wp_localize_script('zl_admin_custom_script', 'wpAjax', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ziai-ajax-nonce')
        ));
    }

    public static function ziai_admin_show_data() {
        // Check user capabilities
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.', 'ziai-articles'));
        }

        if ( is_file(ZIAI_FILE_PATH . 'includes/wp-ziai-article-form.php') ) {
            $token                      = get_option('zl_ziai_access_token');
            $post_type                  = get_option('zl_post_type_get');
            $category                   = get_option('zl_category_get');
            $taxonomies                 = get_option('zl_taxonomy_get');
            $zl_default_author          = get_option('zl_default_author');
            $cron_time                  = get_option('ziai_cron_time');
            $cron_start_time            = get_option('ziai_cron_start_time');
            $errormsg                   = ''; // Initialize error message variable

            if(!empty($_POST) && (isset($_POST['runnow']) || isset($_POST['savechanges']))){
                // Verify nonce
                if (!isset($_POST['zl-ziai-settings']) || !wp_verify_nonce($_POST['zl-ziai-settings'], 'zl-ziai-settings-save')) {
                    wp_die(__('Security check failed. Please try again.', 'ziai-articles'));
                }
                $ziai_access_token          = sanitize_text_field($_POST['ziai_access_token']);
                $post_type                  = sanitize_text_field($_POST['zl_post_type_get']);
                $category                   = sanitize_text_field($_POST['zl_category_get']);
                $taxonomies                 = sanitize_text_field($_POST['zl_taxonomie']);
                $zl_default_author          = sanitize_text_field($_POST['zl_default_author']);
                $cron_time_u                = sanitize_text_field($_POST['ziai_cron_time']);
                $cron_time_u                = round(($cron_time_u * 2), 0) / 2;
                // Compare values properly (handle empty strings)
                $old_cron_start = $cron_start_time ? $cron_start_time : '';
                $new_cron_start = isset($_POST['ziai_cron_start_time']) ? sanitize_text_field($_POST['ziai_cron_start_time']) : '';
                $old_cron_time = $cron_time ? $cron_time : 0;
                
                if ($old_cron_start !== $new_cron_start || $old_cron_time != $cron_time_u) {
                    ZIAI_CronJob::ziai_cronstarter_deactivate();
                }
                $cron_start_time = sanitize_text_field($_POST['ziai_cron_start_time']);
                $cron_time = $cron_time_u;
                update_option('zl_ziai_access_token', $ziai_access_token);
                update_option('zl_post_type_get', $post_type);
                update_option('zl_category_get', $category);
                update_option('zl_taxonomy_get', $taxonomies);
                update_option('ziai_cron_time', $cron_time);
                update_option('ziai_cron_start_time', $cron_start_time);
                update_option('zl_default_author', $zl_default_author);
                // Validate required fields
                if (empty($ziai_access_token)) {
                    $errormsg = __('Error: Access Token is required.', 'ziai-articles');
                } elseif (empty($post_type)) {
                    $errormsg = __('Error: Post Type is required.', 'ziai-articles');
                } elseif (empty($zl_default_author)) {
                    $errormsg = __('Error: Default Author is required.', 'ziai-articles');
                } else {
                    $errormsg = __('Articles settings updated successfully!!', 'ziai-articles');
                    if (isset($_POST['runnow'])) {
                        // Validate access token before import
                        if (empty($token)) {
                            $errormsg = __('Error: Access Token is required to import articles.', 'ziai-articles');
                        } else {
                            $arry = array(
                                "access_token" => $token,
                                "import_post_type" => $post_type,
                                "import_author" => $zl_default_author,
                                "import_taxonomy" => $taxonomies,
                            );
                            $importer_article 	= new ZIAI_Handler($arry);
                            $response           = $importer_article->ziai_import_article();
                            if (isset($response['status']) && $response['status'] == 'errors') {
                                $errormsg = esc_html($response['message']);
                            } elseif (isset($response['status']) && $response['status'] == 'success') {
                                $errormsg = __('Message:- ', 'ziai-articles') . esc_html($response['message']) . '<br>';
                                $errormsg .= __('Episodes:- ', 'ziai-articles') . esc_html($response['count']) . __(' Article Import', 'ziai-articles');
                            } else {
                                $errormsg = __('An unexpected error occurred during import.', 'ziai-articles');
                            }
                        }
                    }
                }
            }
            include_once ZIAI_FILE_PATH . 'includes/wp-ziai-article-form.php';
        }
    }

    //Post Category Get
    public static function ziai_category_get()
    {
        // Check user capabilities
        if (!current_user_can('manage_options')) {
            wp_send_json_error(array('message' => __('You do not have sufficient permissions.', 'ziai-articles')));
            return;
        }

        // Verify nonce if provided
        if (isset($_POST['nonce']) && !wp_verify_nonce($_POST['nonce'], 'ziai-ajax-nonce')) {
            wp_send_json_error(array('message' => __('Security check failed.', 'ziai-articles')));
            return;
        }

        $post_type      = 'zl_ziai_article';
        $taxonomies     = get_object_taxonomies($post_type, 'objects');
        $category       = get_option('zl_category_get');
        
        if (empty($taxonomies)) {
            echo '<label for="zl_get_post_type_category"><b>' . esc_html__('Category', 'ziai-articles') . '</b></label>';
            echo '<select name="zl_category_get"><option value="">' . esc_html__('No taxonomies available', 'ziai-articles') . '</option></select>';
            wp_die();
        }

        // Get first taxonomy key (PHP 7.3+ compatible with fallback for PHP 7.0-7.2)
        if (function_exists('array_key_first')) {
            $taxonomy_key = array_key_first($taxonomies);
        } else {
            $taxonomy_keys = array_keys($taxonomies);
            $taxonomy_key = !empty($taxonomy_keys) ? $taxonomy_keys[0] : null;
        }
        
        if (empty($taxonomy_key)) {
            echo '<label for="zl_get_post_type_category"><b>' . esc_html__('Category', 'ziai-articles') . '</b></label>';
            echo '<select name="zl_category_get"><option value="">' . esc_html__('No taxonomies available', 'ziai-articles') . '</option></select>';
            wp_die();
        }
        echo '<label for="zl_get_post_type_category"><b>' . esc_html__('Category', 'ziai-articles') . '</b></label>';
        echo '<select name="zl_category_get"><option value="">' . esc_html__('Select', 'ziai-articles') . '</option>';
        
        $terms = get_terms(array(
            'taxonomy' => $taxonomy_key,
            'hide_empty' => false,
        ));

        if (!is_wp_error($terms) && !empty($terms)) {
            foreach ($terms as $term) {
                $selected = ($term->term_id == $category) ? 'selected' : '';
                echo '<option value="' . esc_attr($term->term_id) . '" ' . $selected . '>' . esc_html($term->name) . '</option>';
            }
        }
        
        echo '</select><input type="hidden" name="zl_taxonomie" value="' . esc_attr($taxonomy_key) . '">';
        wp_die();
    }

    //custom Post Type
    public static function ziai_register_post_type()
    {
        $cpt_name = 'Automatic Articles Importer';
        $single_item_slug   = 'automatic-article';
        $supports = array(
            'title', // post title
            'editor', // post content
            'author', // post author
            'thumbnail', // featured images
        );
        $labels = array(
            'name' => _x($cpt_name . 's', 'plural'),
            'singular_name' => _x($cpt_name, 'singular'),
            'menu_name' => _x('Automatic Articles Importer', 'admin menu'),
            'name_admin_bar' => _x($cpt_name, 'admin bar'),
            'add_new' => _x('Add New', 'add new'),
            'add_new_item' => __('Add New ' . $cpt_name),
            'new_item' => __('New ' . $cpt_name),
            'edit_item' => __('Edit ' . $cpt_name),
            'view_item' => __('View ' . $cpt_name),
            'all_items' => __('All ' . $cpt_name . 's'),
            'archives' =>  __($cpt_name . 's'),
            'search_items' => __('Search ' . $cpt_name),
            'not_found' => __('No ' . $cpt_name . ' found.'),
        );
        $args = array(
            'menu_icon' => 'dashicons-migrate',
            'supports' => $supports,
            'labels' => $labels,
            'public' => true,
            'query_var' => true,
            'rewrite' => array('slug' => $single_item_slug),
            'has_archive' => true,
            'hierarchical' => true,
        );
        register_post_type('zl_ziai_article', $args);
        $taxonomys = 'Collection';
        $taxonomyp = 'Collections';
        $taxlabels = array(
            'name' => _x($taxonomyp, 'plural'),
            'singular_name' => _x($taxonomys, 'singular'),
            'menu_name' => _x($taxonomyp, 'admin menu'),
            'name_admin_bar' => _x($taxonomys, 'admin bar'),
            'add_new' => _x('Add New', 'add new'),
            'add_new_item' => __('Add New ' . $taxonomys),
            'new_item' => __('New ' . $taxonomys),
            'edit_item' => __('Edit ' . $taxonomys),
            'view_item' => __('View ' . $taxonomys),
            'all_items' => __('All ' . $taxonomyp),
            'search_items' => __('Search ' . $taxonomys),
            'not_found' => __('No ' . $taxonomys . ' found.'),
        );
        register_taxonomy('article-cat', array('zl_ziai_article'), array(
            'hierarchical' => true,
            'labels' => $taxlabels,
            'show_ui' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'article-cat'),
        ));
    }
}