<?php

namespace AutoCraftPlayer\Framework\Support;

use AutoCraftPlayer\Framework\Support\Facades\Config;

class WpOption
{
    protected static $moduleKey;
    
    protected static function prefix(): string
    {
        return '__' . Config::get('app.plugin_prefix') . '_';
    }

    protected static function mergeDefaults($data)
    {
        $defaults = static::$defaults ?? [];
        return array_replace_recursive($defaults, $data);
    }

    public static function get($key = null, $default = null)
    {
        if (static::$moduleKey) {
            $options = self::mergeDefaults(
                get_option(static::prefix() . static::$moduleKey, [])
            );

            if (is_null($key)) {
                return $options;
            }

            if (strpos($key, '.') !== false) {
                $keys  = explode('.', $key);
                $value = $options;
                foreach ($keys as $k) {
                    $value = $value[$k] ?? null;
                }

                return $value ?? $default;
            }

            return $options[$key] ?? $default;
        }

        if (strpos($key, '.') !== false) {
            $keys    = explode('.', $key);
            $mainKey = array_shift($keys);
            $value   = get_option(static::prefix() . $mainKey, []);

            foreach ($keys as $k) {
                $value = $value[$k] ?? null;
            }

            return $value ?? $default;
        }

        return get_option(static::prefix() . $key, $default);
    }

    public static function update($keyOrValue, $value = null)
    {
        if (static::$moduleKey) {
            $optionKey = static::prefix() . static::$moduleKey;
            if (is_null($value)) {
                $data = self::mergeDefaults($keyOrValue);
            } else {
                $currentData = get_option($optionKey, []);
                if (strpos($keyOrValue, '.') !== false) {
                    $keys = explode('.', $keyOrValue);
                    $temp = &$currentData;
                    foreach ($keys as $k) {
                        $temp = &$temp[$k];
                    }
                    $temp = $value;
                } else {
                    $currentData[$keyOrValue] = $value;
                }
                $data = self::mergeDefaults($currentData);
            }
        } else {
            if (strpos($keyOrValue, '.') !== false) {
                $keys        = explode('.', $keyOrValue);
                $mainKey     = array_shift($keys);
                $currentData = get_option(static::prefix() . $mainKey, []);

                $temp = &$currentData;
                foreach ($keys as $k) {
                    if (!isset($temp[$k])) {
                        $temp[$k] = [];
                    }
                    $temp = &$temp[$k];
                }
                $temp = $value;

                $optionKey = static::prefix() . $mainKey;
                $data      = $currentData;
            } else {
                $optionKey = static::prefix() . $keyOrValue;
                $data      = $value;
            }
        }

        update_option($optionKey, $data);

        return new static();
    }

    public static function delete($key = null)
    {
        if (static::$moduleKey) {
            if (is_null($key)) {
                return delete_option(static::prefix() . static::$moduleKey);
            }

            $options = get_option(static::prefix() . static::$moduleKey, []);
            if (strpos($key, '.') !== false) {
                $keys = explode('.', $key);
                $temp = &$options;
                foreach ($keys as $k) {
                    if (!isset($temp[$k])) {
                        return false;
                    }
                    if (next($keys)) {
                        $temp = &$temp[$k];
                    } else {
                        unset($temp[$k]);
                    }
                }
            } else {
                unset($options[$key]);
            }
            $options = self::mergeDefaults($options);

            return update_option(static::prefix() . static::$moduleKey, $options);
        }

        if (strpos($key, '.') !== false) {
            $keys    = explode('.', $key);
            $mainKey = array_shift($keys);
            $options = get_option(static::prefix() . $mainKey, []);

            $temp = &$options;
            foreach ($keys as $k) {
                if (!isset($temp[$k])) {
                    return false;
                }
                if (next($keys)) {
                    $temp = &$temp[$k];
                } else {
                    unset($temp[$k]);
                }
            }

            return update_option(static::prefix() . $mainKey, $options);
        }

        return delete_option(static::prefix() . $key);
    }

    public static function all()
    {
        if (!static::$moduleKey) {
            return [];
        }

        return self::mergeDefaults(
            get_option(static::prefix() . static::$moduleKey, [])
        );
    }
}
