<?php

namespace AutoCraftPlayer\Framework\Support;

use InvalidArgumentException;

class Randomizer
{
    /**
     * Picks a specified number of random keys from an array.
     *
     * @param array $array The input array.
     * @param int $count The number of keys to pick.
     * @return array The picked keys.
     */
    public function pickArrayKeys(array $array, int $count): array
    {
        if ($count > count($array)) {
            throw new InvalidArgumentException("Count cannot be greater than the number of elements in the array.");
        }

        $keys = array_keys($array);
        shuffle($keys);

        return array_slice($keys, 0, $count);
    }

    /**
     * Shuffles the array and returns the shuffled array.
     *
     * @param array $array The input array.
     * @return array The shuffled array.
     */
    public function shuffleArray(array $array): array
    {
        $shuffledArray = $array;
        shuffle($shuffledArray);

        return $shuffledArray;
    }
}
