<?php

namespace AutoCraftPlayer\Framework\Support\Facades;

use AutoCraftPlayer\Framework\Foundation\App;
use Exception;

class Facade
{
    protected static function getFacadeAccessor()
    {
        throw new Exception('Facade does not implement getFacadeAccessor method.');
    }

    /**
     * @throws Exception
     */
    public static function __callStatic($method, $args)
    {
        $instance = static::resolveFacadeInstance(static::getFacadeAccessor());

        if ( ! $instance) {
            throw new Exception('A facade root has not been set.');
        }

        return $instance->$method(...$args);
    }

    protected static function resolveFacadeInstance($name)
    {
        return App::getInstance()->make($name);
    }
}
