<?php

namespace AutoCraftPlayer\Framework\Support;

class DateTime
{
    public static function parse($time = 'now', $timezone = null)
    {
        return new \DateTime($time, $timezone);
    }

    public static function createFromFormat($format, $time, $timezone = null)
    {
        return \DateTime::createFromFormat($format, $time, $timezone);
    }

    public static function createFromTimestamp($timestamp, $timezone = null)
    {
        $dateTime = new \DateTime('@' . $timestamp);
        if ($timezone) {
            $dateTime->setTimezone($timezone);
        }
        return $dateTime;
    }

    public static function now($timezone = null)
    {
        return new \DateTime('now', $timezone);
    }
}
