<?php

namespace AutoCraftPlayer\Framework\Foundation\Http;

use AutoCraftPlayer\Framework\Http\Request;
use AutoCraftPlayer\Framework\Validation\Validator;

class FormRequest extends Request
{
    public function validateResolved(): void
    {
        $this->sanitizeData();

        $validator = new Validator($this->all(), $this->rules(), $this->messages());

        if (!$validator->validate()) {
            $errors       = $validator->errors();
            $errorMessage = $this->formatValidationErrors($errors);
            $response     = [
                'message' => $errorMessage,
                'errors'  => $errors
            ];

            wp_send_json($response, 422);
        }
    }

    public function rules(): array
    {
        return [];
    }

    public function messages(): array
    {
        return [];
    }

    public function sanitizers(): array
    {
        return [];
    }

    protected function sanitizeData(): void
    {
        $sanitizers = $this->sanitizers();

        foreach ($sanitizers as $field => $methods) {
            $value = $this->get($field);
            foreach (explode('|', $methods) as $method) {
                if (function_exists($method)) {
                    $value = call_user_func($method, $value);
                }
            }

            $this->request[$field] = $value;
        }
    }
}
