<?php

namespace AutoCraftPlayer\Framework\Database;

use AutoCraftPlayer\Framework\Container\Container;
use AutoCraftPlayer\Framework\Database\Capsule\Manager as Capsule;
use AutoCraftPlayer\Framework\Database\Events\Dispatcher;

class WPDBConnector
{
    public function __construct()
    {
        $this->init();
    }

    private function init()
    {
        $capsule = $this->getConnectionWithCapsule();
        $capsule->setEventDispatcher(new Dispatcher(new Container()));

        $capsule->setAsGlobal();
        $capsule->bootEloquent();
    }

    private function getPrefix()
    {
        global $wpdb;

        return $wpdb->prefix;
    }

    public static function getCapsuleInstance(): Capsule
    {
        $capsule =  (new static())->getConnectionWithCapsule();
        $capsule->setAsGlobal();

        return $capsule;
    }

    private function getConnectionWithCapsule(): Capsule
    {
        $capsule = new Capsule;

        $capsule->addConnection([
            'driver'    => 'mysql',
            'host'      => DB_HOST,
            'database'  => DB_NAME,
            'username'  => DB_USER,
            'password'  => DB_PASSWORD,
            'prefix'    => $this->getPrefix()
        ]);

        return $capsule;
    }
}
