<?php

namespace AutoCraftPlayer\Framework\Database\Eloquent\Casts;

use AutoCraftPlayer\Framework\Contracts\Database\Eloquent\Castable;
use AutoCraftPlayer\Framework\Contracts\Database\Eloquent\CastsAttributes;
use AutoCraftPlayer\Framework\Support\Str;

class AsStringable implements Castable
{
    /**
     * Get the caster class to use when casting from / to this cast target.
     *
     * @param  array  $arguments
     * @return \AutoCraftPlayer\Framework\Contracts\Database\Eloquent\CastsAttributes<\AutoCraftPlayer\Framework\Support\Stringable, string|\Stringable>
     */
    public static function castUsing(array $arguments)
    {
        return new class implements CastsAttributes
        {
            public function get($model, $key, $value, $attributes)
            {
                return isset($value) ? Str::of($value) : null;
            }

            public function set($model, $key, $value, $attributes)
            {
                return isset($value) ? (string) $value : null;
            }
        };
    }
}
