<?php

namespace AutoCraftPlayer\Framework\Config;

use AutoCraftPlayer\Framework\Foundation\Application;

class Repository
{
    protected array $config = [];
    protected Application $app;

    public function __construct(Application $app)
    {
        $this->app = $app;
        $this->load();
    }

    /**
     * Load configuration files.
     */
    public function load(): void
    {
        $configPath = $this->app['path'] . 'config/';

        foreach (glob($configPath . '*.php') as $file) {
            $key                = basename($file, '.php');
            $this->config[$key] = require $file;
        }
    }

    /**
     * Get a configuration value.
     *
     * @param string $key The configuration key.
     * @param mixed $default The default value if the configuration key does not exist.
     *
     * @return mixed The configuration value.
     */
    public function get($key, $default = null): mixed
    {
        $keys   = explode('.', $key);
        $config = $this->config;

        foreach ($keys as $segment) {
            if (isset($config[$segment])) {
                $config = $config[$segment];
            } else {
                return $default;
            }
        }

        return $config;
    }

    /**
     * Set a configuration value.
     *
     * @param string $key The configuration key.
     * @param mixed $value The configuration value.
     */
    public function set($key, $value): void
    {
        $keys   = explode('.', $key);
        $config =& $this->config;

        foreach ($keys as $segment) {
            if ( ! isset($config[$segment])) {
                $config[$segment] = [];
            }

            $config =& $config[$segment];
        }

        $config = $value;
    }
}
