<?php

if (!defined('ABSPATH')) {
    exit;
}

use AutoCraftPlayer\App\Http\Controllers\DashboardController;
use AutoCraftPlayer\App\Http\Controllers\MediumController;
use AutoCraftPlayer\Framework\Support\Facades\Route;
use AutoCraftPlayer\App\Http\Controllers\GlobalSettingController;
use AutoCraftPlayer\App\Http\Controllers\VideoController;
use AutoCraftPlayer\App\Http\Controllers\AudioController;
use AutoCraftPlayer\App\Http\Controllers\PlaylistController;
use AutoCraftPlayer\App\Http\Middleware\Authentication;
use AutoCraftPlayer\App\Http\Controllers\PlaylistItemController;
use AutoCraftPlayer\App\Http\Controllers\UploadController;

Route::group(['prefix' => 'global-settings', 'middleware' => [Authentication::class]], function () {
    Route::get('/', [GlobalSettingController::class, 'index']);
    Route::post('/', [GlobalSettingController::class, 'store']);
    Route::get('/pages', [GlobalSettingController::class, 'getWpPages']);
});


Route::group(['prefix' => 'dashboards', 'middleware' => [Authentication::class]], function () {
    Route::get('/stats', [DashboardController::class, 'stats']);
});

Route::group(['prefix' => 'media', 'middleware' => [Authentication::class]], function () {
    Route::get('/', [MediumController::class, 'index']);
});

Route::group(['prefix' => 'audios', 'middleware' => [Authentication::class]], function () {
    Route::get('/', [AudioController::class, 'index']);
    Route::post('/', [AudioController::class, 'store']);
    Route::delete('/{id}', [AudioController::class, 'destroy']);
    Route::put('/{id}', [AudioController::class, 'update']);
    Route::get('/{id}', [AudioController::class, 'edit']);
    Route::post('/bulk-actions', [AudioController::class, 'bulkActions']);
    Route::put('/{id}/playlists', [AudioController::class, 'updatePlaylistsForMedia']);
});

Route::group(['prefix' => 'videos', 'middleware' => [Authentication::class]], function () {
    Route::get('/', [VideoController::class, 'index']);
    Route::post('/', [VideoController::class, 'store']);
    Route::delete('/{id}', [VideoController::class, 'destroy']);
    Route::put('/{id}', [VideoController::class, 'update']);
    Route::get('/{id}', [VideoController::class, 'edit']);
    Route::post('/bulk-actions', [VideoController::class, 'bulkActions']);
    Route::put('/{id}/playlists', [VideoController::class, 'updatePlaylistsForMedia']);
});

Route::get('playlists/{id}/media', [PlaylistController::class, 'getMediaByPlaylist']);

Route::middleware([Authentication::class])->group(['prefix' => 'playlists'], function () {
    Route::get('/', [PlaylistController::class, 'index']);
    Route::post('/', [PlaylistController::class, 'store']);
    Route::delete('/{id}', [PlaylistController::class, 'destroy']);
    Route::get('/{id}', [PlaylistController::class, 'edit']);
    Route::put('/{id}', [PlaylistController::class, 'update']);
    Route::post('/bulk-actions', [PlaylistController::class, 'bulkActions']);

    Route::group(['prefix' => '/{playlistId}/items'], function () {
        Route::delete('/{id}', [PlaylistItemController::class, 'destroy']);
    });
});

Route::group(['middleware' => [Authentication::class], 'prefix' => 'uploads'], function () {
    Route::post('/', [UploadController::class, 'store']);
    Route::delete('/{uid}', [UploadController::class, 'destroy']);
});
