<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Custom options for video player
 * icons can be svg/html or text
 */

$config = [
    // extra custom options
    'provider'      => 'local',
    'layout'        => 'default',
    'theme_type'    => 'pre_defined',

    // common options
    'preload'       => 'auto',
    'autoplay'      => false,
    'loop'          => false,
    'muted'         => false,
    'poster'        => 'https://vjs.zencdn.net/v/oceans.png',
    'height'        => 280,
    'width'         => 600,

    // videojs options
    'volume'        => .5,
    'fluid'         => true,
    "sources"       => [
        [
            "type" => "video/mp4",
            "src"  => "https://vjs.zencdn.net/v/oceans.mp4"
        ]
    ],
    "techOrder"     => ["html5", "youtube", 'vimeo'],
    "playbackRates" => [0.5, .75, 1, 1.25, 1.5],
    "playbackRate"  => 1,
    // control bar options
    'audioOnlyMode' => false,
    'controls'      => true,
    'controlBar'    => (new \AutoCraftPlayer\App\Helpers\PlayerControls())->getVideoControlBarConfig()
];

return $config;
