<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Custom options for video player
 * icons can be svg/html or text
 */

$config = [
    // extra custom options
    'provider'      => 'local',
    'layout'        => 'default',
    'theme_type'    => 'pre_defined',

    // common options
    'preload'       => 'auto',
    'autoplay'      => false,
    'loop'          => false,
    'muted'         => false,
    'poster'        => '',
    'height'        => 280,
    'width'         => 600,

    // videojs options
    'volume'        => .5,
    'fluid'         => true,
    "sources"       => [
        [
            "type" => "audio/mp3",
            "src"  => "https://sample-videos.com/audio/mp3/wave.mp3"
        ]
    ],
    "techOrder"     => ["html5", "youtube", 'vimeo'],
    "playbackRates" => [0.5, .75, 1, 1.25, 1.5],
    "playbackRate"  => 1,
    // control bar options
    'audioOnlyMode' => true,
    'controls'      => true,
    'controlBar'    => (new \AutoCraftPlayer\App\Helpers\PlayerControls())->getAudioControlBarConfig()
];

return $config;
