<?php

namespace AutoCraftPlayer {

    use AutoCraftPlayer\App\Models\Meta;
    use AutoCraftPlayer\App\Services\Helper;
    use AutoCraftPlayer\Framework\Http\Request;

    function adminRole()
    {
        if (current_user_can('administrator')) {
            return 'administrator';
        }

        $roles = apply_filters('autocraft_player/admin_roles', array('administrator'));

        if (is_string($roles)) {
            $roles = array($roles);
        }

        foreach ($roles as $role) {
            if (current_user_can($role)) {
                return $role;
            }
        }

        return false;
    }

    function sanitizeArray($value)
    {
        if (is_array($value)) {
            return array_map('\AutoCraftPlayer\sanitizeArray', $value);
        }

        if (is_string($value) && preg_match('/^\s*<svg[\s>]/i', $value)) {
            return Helper::sanitizeSVG($value);
        }

        if (Helper::isCustomJsField($value)) {
            return Helper::sanitizeJS($value);
        }

        if ($value) {
            return wp_kses_post($value);
        }

        return $value;
    }

    function arrayMergeRecursive($array1, $array2)
    {
        foreach ($array2 as $key => $value) {
            if (array_key_exists($key, $array1) && is_array($value)) {
                $array1[$key] = arrayMergeRecursive($array1[$key], $array2[$key]);
            } else {
                $array1[$key] = $value;
            }
        }

        return $array1;
    }

    function request()
    {
        return Request::capture();
    }

    function updateOption($key, $value)
    {
        return Meta::updateMeta($key, $value, 'option');
    }

    function getOption($key)
    {
        $option = Meta::getMeta($key, 'option');

        if ($option) {
            return $option['meta_value'];
        }
    }

    function deleteOption($key)
    {
        return Meta::where('meta_key', $key)->delete();
    }
}

