<?php

if (!defined('ABSPATH')) {
    exit;
}

use AutoCraftPlayer\Framework\Foundation\Application;
use AutoCraftPlayer\App\Hooks\Handlers\ActivationHandler;
use AutoCraftPlayer\App\Hooks\Handlers\DeactivationHandler;

return function ($file) {
    $app = new Application($file);

    register_activation_hook($file, function () {
        (new ActivationHandler())->handle();
    });

    register_deactivation_hook($file, function () {
        (new DeactivationHandler())->handle();
    });

    add_action('plugins_loaded', function () use ($app) {
        do_action('autocraft_player/loaded', $app);
    });
};
