import{R as w}from"../Rest.js";import{A as C}from"../AutoCraftPlayer.js";import"../VjsPlayer.js";class I{constructor(t,i=[],e={}){this.player=t,this.config={autoplay:e.autoplay??!1,repeat:e.repeat??!1,shuffle:e.shuffle??!1,autoplayDelay:e.autoplayDelay??0,maxItems:e.maxItems??0,allowedTypes:e.allowedTypes||[]},this._items=[],this._originalItems=[],this._currentIndex=-1,this._playbackEvents={},this._validatePlayer(),this._setupPlayerEvents(),i.length&&this.add(i)}_validatePlayer(){if(!this.player||typeof this.player.on!="function")throw new Error("Invalid Video.js player instance")}_setupPlayerEvents(){this._destroyPlayerEvents(),this._playbackEvents.ended=()=>this._handlePlaylistEnd(),this.player.on("ended",this._playbackEvents.ended)}_destroyPlayerEvents(){Object.keys(this._playbackEvents).forEach(t=>{this.player.off(t,this._playbackEvents[t])})}_handlePlaylistEnd(){this.config.repeat?this.first():this.config.shuffle?(this.shuffle(),this.first()):this.next()}_normalizeItem(t){const i=this.config.allowedTypes.length===0?t.sources||[]:(t.sources||[]).filter(e=>this.config.allowedTypes.includes(e.type));return{id:t.id||this._generateUniqueId(),title:t.title||"Untitled Media",sources:i,poster:t.poster||"",tracks:t.tracks||[],meta:t.meta||{}}}_generateUniqueId(){return`playlist_item_${Date.now()}_${Math.random().toString(36).substr(2,9)}`}add(t,i){const s=(Array.isArray(t)?t:[t]).map(r=>this._normalizeItem(r));if(this.config.maxItems>0&&this._items.length+s.length>this.config.maxItems)throw new Error(`Cannot add more than ${this.config.maxItems} items`);return i!==void 0&&i>=0&&i<=this._items.length?this._items.splice(i,0,...s):this._items.push(...s),this._originalItems=[...this._items],this._currentIndex===-1&&this._items.length>0&&this.currentItem(0),s}remove(t){let i=-1;if(typeof t=="string"?i=this._items.findIndex(s=>s.id===t):typeof t=="number"&&(i=t),i<0||i>=this._items.length)return null;const e=this._items.splice(i,1)[0];return this._currentIndex>=this._items.length&&(this._currentIndex=Math.max(0,this._items.length-1)),e}currentItem(t){if(t===void 0)return this._currentIndex;if(t<0||t>=this._items.length)return-1;this._currentIndex=t;const i=this._items[t];return i&&(this.player.src(i.sources),i.poster&&this.player.poster(i.poster),this._updateTextTracks(i),this.config.autoplay&&this._delayedPlay()),t}_updateTextTracks(t){const i=this.player.remoteTextTracks();for(let e=i.length-1;e>=0;e--)this.player.removeRemoteTextTrack(i[e]);t.tracks&&t.tracks.forEach(e=>{this.player.addRemoteTextTrack(e,!1)})}_delayedPlay(){this.config.autoplayDelay>0?setTimeout(()=>this.player.play(),this.config.autoplayDelay*1e3):this.player.play()}currentIndex(){return this._currentIndex}first(){return this._items.length?this.currentItem(0):null}last(){return this._items.length?this.currentItem(this._items.length-1):null}next(){const t=this._getNextIndex();return t!==-1?this.currentItem(t):null}previous(){const t=this._getPreviousIndex();return t!==-1?this.currentItem(t):null}_getNextIndex(){if(this._currentIndex===-1)return-1;const t=this._items.length-1;return this.config.repeat&&this._currentIndex===t?0:Math.min(this._currentIndex+1,t)}_getPreviousIndex(){return this._currentIndex===-1?-1:this.config.repeat&&this._currentIndex===0?this._items.length-1:Math.max(this._currentIndex-1,0)}shuffle(t={}){const{rest:i=!1}=t;let e=0,s=this._items.length;i&&this._currentIndex!==-1&&(e=this._currentIndex+1);for(let r=s-1;r>e;r--){const l=e+Math.floor(Math.random()*(r-e+1));[this._items[r],this._items[l]]=[this._items[l],this._items[r]]}return this}reset(){return this._items=[...this._originalItems],this._currentIndex=-1,this}indexOf(t){if(typeof t=="string")return this._items.findIndex(e=>e.sources.some(s=>s.src===t));const i=Array.isArray(t)?t:t.sources;return this._items.findIndex(e=>i.some(s=>e.sources.some(r=>r.src===s.src)))}contains(t){return this.indexOf(t)!==-1}getItems(){return[...this._items]}setConfig(t){return this.config={...this.config,...t},this._setupPlayerEvents(),this}destroy(){this._destroyPlayerEvents(),this._items=[],this._originalItems=[],this._currentIndex=-1}}class h{static filterPlaylistItems(t,i,e,s){t(`#${i} .${e}-playlist-item, #${i} .${e}-chapter-item`).each((r,l)=>{const a=t(l);a.find(`.${e}-item-title, .${e}-chapter-title, .${e}-video-item-title`).text().toLowerCase().includes(s)||s===""?a.show():a.hide()})}static getColorPalette(t,i=null,e=null){const s={light:{bgColor:"#FFFFFF",textColor:"#333333",headerBg:"#F5F5F5",borderColor:"#E0E0E0",itemBorderColor:"#EEEEEE",itemHoverBg:"#F9F9F9",itemActiveBg:"#F0F0F0",mutedTextColor:"#777777",placeholderColor:"#999999",scrollbarTrackBg:"#F0F0F0",scrollbarThumbBg:"#CCCCCC",scrollbarThumbHoverBg:"#BBBBBB",searchBg:"#EEEEEE",descriptionColor:"#666666",cardBg:"#FFFFFF",inputBg:"#F8F8F8",shadow:"rgba(0, 0, 0, 0.1)"},dark:{bgColor:"#222222",textColor:"#FFFFFF",headerBg:"#333333",borderColor:"#444444",itemBorderColor:"#3A3A3A",itemHoverBg:"#2A2A2A",itemActiveBg:"#2C2C2C",mutedTextColor:"#AAAAAA",placeholderColor:"#888888",scrollbarTrackBg:"#2A2A2A",scrollbarThumbBg:"#555555",scrollbarThumbHoverBg:"#666666",searchBg:"#3D3D3D",descriptionColor:"#CCCCCC",cardBg:"#2D2D2D",inputBg:"#333333",shadow:"rgba(0, 0, 0, 0.4)"},sepia:{bgColor:"#F8F1E3",textColor:"#5F4B32",headerBg:"#EFE6D5",borderColor:"#DAC9A6",itemBorderColor:"#E5D9C3",itemHoverBg:"#F0E8D9",itemActiveBg:"#E8DECB",mutedTextColor:"#8C7B68",placeholderColor:"#A99B87",scrollbarTrackBg:"#E8DECB",scrollbarThumbBg:"#C0AB8A",scrollbarThumbHoverBg:"#B09776",searchBg:"#EFE6D5",descriptionColor:"#7A6854",cardBg:"#FCF7ED",inputBg:"#F4EDE0",shadow:"rgba(95, 75, 50, 0.15)"},highContrast:{bgColor:"#000000",textColor:"#FFFFFF",headerBg:"#222222",borderColor:"#FFFFFF",itemBorderColor:"#FFFFFF",itemHoverBg:"#333333",itemActiveBg:"#444444",mutedTextColor:"#FFFFFF",placeholderColor:"#CCCCCC",scrollbarTrackBg:"#333333",scrollbarThumbBg:"#FFFFFF",scrollbarThumbHoverBg:"#DDDDDD",searchBg:"#222222",descriptionColor:"#FFFFFF",cardBg:"#222222",inputBg:"#000000",shadow:"rgba(255, 255, 255, 0.2)"}},l={...s[t]||s.light};if(i?typeof i=="string"?(l.nowPlayingBg=i,l.accentColor=i):typeof i=="object"&&Object.assign(l,i):(l.nowPlayingBg="#E74C3C",l.accentColor="#E74C3C"),e){const o={indigo:{primary:t==="dark"?"#6366f1":"#4f46e5",primaryLight:t==="dark"?"#818cf8":"#6366f1",primaryDark:t==="dark"?"#4338ca":"#3730a3",accentColor:"#4f46e5"},emerald:{primary:t==="dark"?"#34d399":"#10b981",primaryLight:t==="dark"?"#6ee7b7":"#34d399",primaryDark:t==="dark"?"#059669":"#047857",accentColor:"#10b981"},amber:{primary:t==="dark"?"#fbbf24":"#f59e0b",primaryLight:t==="dark"?"#fcd34d":"#fbbf24",primaryDark:t==="dark"?"#d97706":"#b45309",accentColor:"#f59e0b"},rose:{primary:t==="dark"?"#fb7185":"#f43f5e",primaryLight:t==="dark"?"#fda4af":"#fb7185",primaryDark:t==="dark"?"#e11d48":"#be123c",accentColor:"#f43f5e"},slate:{primary:t==="dark"?"#64748b":"#475569",primaryLight:t==="dark"?"#94a3b8":"#64748b",primaryDark:t==="dark"?"#334155":"#1e293b",accentColor:"#475569"},ocean:{primary:t==="dark"?"#38bdf8":"#0ea5e9",primaryLight:t==="dark"?"#7dd3fc":"#38bdf8",primaryDark:t==="dark"?"#0284c7":"#0369a1",accentColor:"#0ea5e9"},purple:{primary:t==="dark"?"#a855f7":"#9333ea",primaryLight:t==="dark"?"#c084fc":"#a855f7",primaryDark:t==="dark"?"#7e22ce":"#6b21a8",accentColor:"#9333ea"}}[e];o&&(Object.assign(l,o),l.nowPlayingBg=o.accentColor)}return l}static createCustomTheme(t,i){return{...this.getColorPalette(t),...i}}static getGradientStyles(t,i,e=100){const s=Math.round(e*2.55).toString(16).padStart(2,"0"),r=t==="dark",l={gradient:{bg:r?"linear-gradient(135deg, #0f172a 0%, #1e293b 100%)":"linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%)",item:r?`linear-gradient(90deg, #10b981${s} 0%, transparent 100%)`:`linear-gradient(90deg, #10b981${s} 0%, transparent 100%)`},vibrant:{bg:r?"linear-gradient(135deg, #18181b 0%, #3f3f46 100%)":"linear-gradient(135deg, #fef2f2 0%, #fee2e2 100%)",item:r?`linear-gradient(90deg, #be123c${s} 0%, transparent 100%)`:`linear-gradient(90deg, #be123c${s} 0%, transparent 100%)`},indigo:{bg:r?"linear-gradient(135deg, #1e1b4b 0%, #3730a3 100%)":"linear-gradient(135deg, #eef2ff 0%, #e0e7ff 100%)",item:r?`linear-gradient(90deg, #4f46e5${s} 0%, transparent 100%)`:`linear-gradient(90deg, #4f46e5${s} 0%, transparent 100%)`},amber:{bg:r?"linear-gradient(135deg, #451a03 0%, #92400e 100%)":"linear-gradient(135deg, #fffbeb 0%, #fef3c7 100%)",item:r?`linear-gradient(90deg, #f59e0b${s} 0%, transparent 100%)`:`linear-gradient(90deg, #f59e0b${s} 0%, transparent 100%)`},minimal:{bg:r?"#18181b":"#ffffff",item:r?"#27272a":"#f8fafc"}};return l[i]||l.gradient}static getCommonStyles(t,i){return`
            /* Toggle button */
            .${t}-toggle-btn {
                position: absolute;
                top: 10px;
                right: 10px;
                width: 32px;
                height: 32px;
                background: rgba(0, 0, 0, 0.5);
                border: none;
                border-radius: 3px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                z-index: 5;
                color: white;
                padding: 0;
            }
            
            /* Search box */
            .${t}-search-box {
                width: 100%;
                max-width: 300px;
            }
            
            .${t}-search-wrapper {
                position: relative;
                width: 100%;
            }
            
            .${t}-search-icon {
                position: absolute;
                left: 12px;
                top: 50%;
                transform: translateY(-50%);
                color: ${i.placeholderColor};
            }
            
            .${t}-search-input {
                width: 100% !important;
                padding: 8px 12px 8px 36px !important;
                border: 1px solid ${i.borderColor};
                border-radius: 4px;
                font-size: 14px;
                line-height: 1.5;
                color: ${i.textColor};
                background: ${i.searchBg};
                transition: all 0.2s;
                outline: none;
            }
            
            .${t}-search-input:focus {
                border-color: ${i.accentColor||i.nowPlayingBg};
            }
            
            .${t}-search-input::placeholder {
                color: ${i.placeholderColor};
            }
            
            /* Scrollbar */
            .${t}-items::-webkit-scrollbar,
            .${t}-playlist-grid::-webkit-scrollbar,
            .${t}-playlist-scroll::-webkit-scrollbar {
                width: 6px;
                height: 6px;
            }
            
            .${t}-items::-webkit-scrollbar-track,
            .${t}-playlist-grid::-webkit-scrollbar-track,
            .${t}-playlist-scroll::-webkit-scrollbar-track {
                background: ${i.scrollbarTrackBg};
            }
            
            .${t}-items::-webkit-scrollbar-thumb,
            .${t}-playlist-grid::-webkit-scrollbar-thumb,
            .${t}-playlist-scroll::-webkit-scrollbar-thumb {
                background: ${i.scrollbarThumbBg};
                border-radius: 3px;
            }
            
            .${t}-items::-webkit-scrollbar-thumb:hover,
            .${t}-playlist-grid::-webkit-scrollbar-thumb:hover,
            .${t}-playlist-scroll::-webkit-scrollbar-thumb:hover {
                background: ${i.scrollbarThumbHoverBg};
            }
        `}}class d{constructor(t){var i;this.player=t.player,this.playlist=t.playlist,this.playlistItems=t.playlistItems,this.playlistModel=t.playlistModel,this.config=((i=this.playlistModel.meta)==null?void 0:i.config)||{},this.instance=this.playlistModel.instance,this.id=this.playlistModel.id,this.type=this.playlistModel.type,this.layout=this.config.layout||"default",this.cssPrefix=`autocraft_player-playlist-${this.layout}`,this.$=window.jQuery,this.container=null,this.playlistId=`${this.instance}_${this.id}_playlist`,this.playlistContainer=null,this.playlistSection=null,this.searchInput=null,this.config={...this.config,themeMode:this.config.themeMode||"light",showPlaylist:this.config.showPlaylist!==!1,showSearch:this.config.showSearch!==!1,showTitle:this.config.showTitle!==!1,showDescription:this.config.showDescription!==!1},this.renderDefaultControls()}getBaseSelector(){return`#${this.instance}_${this.id}`}createContainer(){return this.container=document.querySelector(this.getBaseSelector()),this.container?!0:(console.error("Playlist container not found:",this.getBaseSelector()),!1)}render(){this.createContainer()&&(this.$(`#${this.instance}`).parent().css("position","relative"),this.createLayout(),this.renderPlaylistItems(),this.setupEventListeners(),this.injectStyles(),this.createToggleButton(),this.config.showPlaylist===!1&&this.$(this.playlistSection).hide(),setTimeout(()=>{this.highlightActiveItem(this.playlist.currentIndex())},100))}renderDefaultControls(){var t,i,e;this.playlist.setConfig({autoplay:((t=this.config)==null?void 0:t.autoplay)||!1,repeat:((i=this.config)==null?void 0:i.repeat)||!1,shuffle:((e=this.config)==null?void 0:e.shuffle)||!1,autoplayDelay:0,maxItems:0,allowedTypes:[]})}createLayout(){console.warn(`${this.layout}: createLayout method should be implemented by subclass`)}renderPlaylistItems(){console.warn(`${this.layout}: renderPlaylistItems method should be implemented by subclass`)}highlightActiveItem(t){console.warn(`${this.layout}: highlightActiveItem method should be implemented by subclass`)}setupEventListeners(){this.player.on("play",()=>{this.highlightActiveItem(this.playlist.currentIndex())}),this.player.on("loadstart",()=>{this.highlightActiveItem(this.playlist.currentIndex())}),this.player.on("loadedmetadata",()=>{this.highlightActiveItem(this.playlist.currentIndex())}),this.player.on("ended",()=>{setTimeout(()=>{this.highlightActiveItem(this.playlist.currentIndex())},50)})}injectStyles(){console.warn(`${this.layout}: injectStyles method should be implemented by subclass`)}createToggleButton(){const t=this.$("<button>").addClass(`${this.cssPrefix}-toggle-btn`).html(`
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24">
                    <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z" fill="currentColor"/>
                </svg>
            `);this.$(`#${this.instance}`).parent().append(t),t.on("click",()=>{this.$(this.playlistSection).toggle()})}createSearchBox(t){if(this.config.showSearch!==!1){const i=this.$("<div>").addClass(`${this.cssPrefix}-search-box`).html(`
                    <div class="${this.cssPrefix}-search-wrapper">
                        <svg class="${this.cssPrefix}-search-icon" viewBox="0 0 24 24" width="18" height="18" stroke="currentColor" stroke-width="2" fill="none">
                            <circle cx="11" cy="11" r="8"></circle>
                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                        <input type="text" placeholder="Search videos..." class="${this.cssPrefix}-search-input">
                    </div>
                `).appendTo(t);return this.searchInput=i.find(`.${this.cssPrefix}-search-input`),i}return null}setupSearchFunctionality(){this.config.showSearch!==!1&&this.searchInput&&this.searchInput.on("input",t=>{const i=this.$(t.currentTarget).val().toLowerCase();h.filterPlaylistItems(this.$,this.playlistId,this.cssPrefix,i)})}}class u extends d{constructor(t){super(t)}createLayout(){this.$(`#${this.instance}`).parent().css("position","relative"),this.createPlaylist()}createPlaylist(){this.playlistContainer=this.$("<div>").addClass(`${this.cssPrefix}-playlist`).attr("id",`${this.instance}_playlist`),this.$(this.container).append(this.playlistContainer),this.playlistSection=this.playlistContainer,this.renderHtml()}renderHtml(){const t=this.$("<div>").addClass(`${this.cssPrefix}-header`).appendTo(this.playlistContainer);this.$("<div>").addClass(`${this.cssPrefix}-playlist-label`).text("PLAYLIST").appendTo(t),this.config.showSearch!==!1&&this.createSearchBox(t),this.$("<div>").addClass(`${this.cssPrefix}-menu-toggle`).html(`
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24">
                    <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z" fill="currentColor"/>
                </svg>
            `).appendTo(t);const i=this.$("<div>").addClass(`${this.cssPrefix}-items`).attr("id",this.playlistId).appendTo(this.playlistContainer);if(this.playlistItems.forEach((e,s)=>{const r=this.$("<div>").addClass(`${this.cssPrefix}-item ${this.cssPrefix}-playlist-item`).attr("data-index",s).appendTo(i);e.poster&&this.$("<div>").addClass(`${this.cssPrefix}-item-thumbnail`).html(`<img src="${e.poster}" alt="${e.title||""}">`).appendTo(r);const l=this.$("<div>").addClass(`${this.cssPrefix}-item-content`).appendTo(r);if(e.title&&this.$("<div>").addClass(`${this.cssPrefix}-item-title`).text(e.title).appendTo(l),e.duration){const a=this.$("<div>").addClass(`${this.cssPrefix}-item-duration`).appendTo(l);this.$("<span>").text(e.duration).appendTo(a),this.$("<span>").addClass(`${this.cssPrefix}-now-playing`).text("NOW PLAYING").appendTo(a)}}),this.config.showTitle!==!1&&this.playlistModel.title||this.config.showDescription!==!1&&this.playlistModel.description){const e=this.$("<div>").addClass(`${this.cssPrefix}-info`).insertAfter(`#${this.instance}`);this.config.showTitle!==!1&&this.playlistModel.title&&this.$("<h2>").addClass(`${this.cssPrefix}-playlist-title`).text(this.playlistModel.title).appendTo(e),this.config.showDescription!==!1&&this.playlistModel.description&&this.$("<p>").addClass(`${this.cssPrefix}-playlist-description`).text(this.playlistModel.description).appendTo(e)}}renderPlaylistItems(){}setupEventListeners(){super.setupEventListeners(),this.$(`#${this.instance}_playlist .${this.cssPrefix}-item`).on("click",t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.setupSearchFunctionality(),this.$(`#${this.instance}_playlist .${this.cssPrefix}-menu-toggle`).on("click",()=>{this.$(this.playlistContainer).toggle()})}highlightActiveItem(t){if(t===-1||t===void 0)return;this.$(`#${this.instance}_playlist .${this.cssPrefix}-item`).removeClass("active"),this.$(`#${this.instance}_playlist .${this.cssPrefix}-now-playing`).hide();const i=this.$(`#${this.instance}_playlist .${this.cssPrefix}-item[data-index="${t}"]`);if(i.length){i.addClass("active"),i.find(`.${this.cssPrefix}-now-playing`).show();const e=this.$(`#${this.instance}_playlist .${this.cssPrefix}-items`),s=i.position().top,r=i.outerHeight(),l=e.height(),a=e.scrollTop();(s<0||s+r>l)&&e.animate({scrollTop:a+s-l/2+r/2},200)}}injectStyles(){const t=`${this.cssPrefix}-styles`;if(document.getElementById(t))return;const i=h.getColorPalette(this.config.themeMode);this.$(`<style id="${t}">
            /* Common styles from PlaylistUtils */
            ${h.getCommonStyles(this.cssPrefix,i)}
            
            /* Playlist container */
            .${this.cssPrefix}-playlist {
                position: absolute;
                top: 0;
                right: 0;
                width: 320px;
                height: 100%;
                background-color: ${i.bgColor};
                color: ${i.textColor};
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial, sans-serif;
                border-left: 1px solid ${i.borderColor};
                display: flex;
                flex-direction: column;
                z-index: 10;
            }
            
            .autocraft_player-playlist-audio .${this.cssPrefix}-playlist {
                width: 100%;
                height: 100%;
                top:100%;
                min-height: 300px;
            }
            
            /* Header with search */
            .${this.cssPrefix}-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 10px 15px;
                background-color: ${i.headerBg};
                border-bottom: 1px solid ${i.borderColor};
            }
            
            .${this.cssPrefix}-playlist-label {
                font-size: 16px;
                font-weight: 600;
                text-transform: uppercase;
                white-space: nowrap;
            }
            
            .${this.cssPrefix}-menu-toggle {
                cursor: pointer;
                padding: 5px;
                margin-left: 5px;
            }
            
            .${this.cssPrefix}-menu-toggle svg {
                width: 24px;
                height: 24px;
                fill: ${i.textColor};
            }
            
            /* Playlist items */
            .${this.cssPrefix}-items {
                flex: 1;
                overflow-y: auto;
            }
            
            .${this.cssPrefix}-item {
                display: flex;
                padding: 10px 15px;
                border-bottom: 1px solid ${i.itemBorderColor};
                cursor: pointer;
                transition: background-color 0.2s;
            }
            
            .${this.cssPrefix}-item:hover {
                background-color: ${i.itemHoverBg};
            }
            
            .${this.cssPrefix}-item.active {
                background-color: ${i.itemActiveBg};
            }
            
            .${this.cssPrefix}-item-thumbnail {
                width: 80px;
                height: 45px;
                margin-right: 12px;
                flex-shrink: 0;
                overflow: hidden;
            }
            
            .${this.cssPrefix}-item-thumbnail img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            
            .${this.cssPrefix}-item-content {
                flex: 1;
                display: flex;
                flex-direction: column;
                justify-content: center;
                min-width: 0;
            }
            
            .${this.cssPrefix}-item-title {
                font-size: 14px;
                line-height: 1.3;
                margin-bottom: 4px;
                overflow: hidden;
                text-overflow: ellipsis;
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
            }
            
            .${this.cssPrefix}-item-duration {
                font-size: 13px;
                color: ${i.mutedTextColor};
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            
            .${this.cssPrefix}-now-playing {
                font-size: 10px;
                color: #FFFFFF;
                background-color: ${i.nowPlayingBg};
                padding: 2px 5px;
                border-radius: 2px;
                display: none;
            }
            
            /* Info section below player */
            .${this.cssPrefix}-info {
                margin: 15px 0 30px 0;
                color: ${i.textColor};
                background: ${i.bgColor};
                padding: 10px 10px;
            }
            
            .${this.cssPrefix}-playlist-title {
                font-size: 22px;
                font-weight: 600;
                margin: 0 0 10px 0;
                color: ${i.textColor};
            }
            
            .${this.cssPrefix}-playlist-description {
                font-size: 14px;
                line-height: 1.5;
                margin: 0;
                color: ${i.descriptionColor};
            }
        </style>`).appendTo("head")}}class $ extends d{constructor(t){super(t),this.config={...this.config,colorTheme:this.playlistModel.colorTheme||"indigo",columnsDesktop:this.playlistModel.columnsDesktop||3,columnsTablet:this.playlistModel.columnsTablet||2,columnsMobile:this.playlistModel.columnsMobile||1},this.videoTitleElement=null,this.videoDateElement=null,this.descriptionElement=null,this.playlistCountElement=null,this.playlistGridElement=null,this.gridViewBtn=null,this.listViewBtn=null}createLayout(){const t=this.$("<div>").addClass(`${this.cssPrefix}-wrapper`).attr("id",`${this.instance}_grid_wrapper`),i=this.$("<div>").addClass(`${this.cssPrefix}-player-section`),e=this.$(`#${this.instance}`);this.playlistSection=this.$("<div>").addClass(`${this.cssPrefix}-playlist-section`).attr("id",`${this.instance}_playlist_section`);const s=this.$("<div>").addClass(`${this.cssPrefix}-playlist-header`);this.config.showSearch!==!1&&this.createSearchBox(s);const r=this.$("<div>").addClass(`${this.cssPrefix}-view-controls`).html(`
                <button class="${this.cssPrefix}-grid-view-btn active" aria-label="Grid View" title="Grid View">
                    <svg viewBox="0 0 24 24" width="20" height="20" stroke="currentColor" stroke-width="2" fill="none">
                        <rect x="3" y="3" width="7" height="7" />
                        <rect x="14" y="3" width="7" height="7" />
                        <rect x="3" y="14" width="7" height="7" />
                        <rect x="14" y="14" width="7" height="7" />
                    </svg>
                </button>
                <button class="${this.cssPrefix}-list-view-btn" aria-label="List View" title="List View">
                    <svg viewBox="0 0 24 24" width="20" height="20" stroke="currentColor" stroke-width="2" fill="none">
                        <line x1="3" y1="6" x2="21" y2="6" />
                        <line x1="3" y1="12" x2="21" y2="12" />
                        <line x1="3" y1="18" x2="21" y2="18" />
                    </svg>
                </button>
            `).appendTo(s);this.playlistSection.append(s),this.playlistGridElement=this.$("<div>").addClass(`${this.cssPrefix}-playlist-grid`).attr("id",`${this.playlistId}`).appendTo(this.playlistSection),this.playlistContainer=this.playlistSection;let l=null;(this.config.showTitle!==!1||this.config.showDescription!==!1)&&(l=this.$("<div>").addClass(`${this.cssPrefix}-info-section`),this.config.showTitle!==!1&&(this.videoTitleElement=this.$("<h2>").addClass(`${this.cssPrefix}-video-title`).text("Loading...").appendTo(l)),this.config.showDescription!==!1&&(this.descriptionElement=this.$("<div>").addClass(`${this.cssPrefix}-description`).html("<p>Loading description...</p>").appendTo(l))),e.length&&i.append(e),t.append(i),t.append(this.playlistSection),l&&t.append(l),this.$(this.container).empty().append(t),this.gridViewBtn=r.find(`.${this.cssPrefix}-grid-view-btn`),this.listViewBtn=r.find(`.${this.cssPrefix}-list-view-btn`)}renderPlaylistItems(){!this.playlistGridElement||!this.playlistItems.length||(this.playlistGridElement.empty(),this.playlistItems.forEach((t,i)=>{const e=this.$("<div>").addClass(`${this.cssPrefix}-playlist-item`).attr("data-index",i);i===this.playlist.currentIndex()&&e.addClass("active");const s=t.duration||"00:00";e.html(`
                <div class="${this.cssPrefix}-item-inner">
                    <div class="${this.cssPrefix}-item-thumbnail">
                        <img src="${t.poster||""}" alt="Video thumbnail">
                        <div class="${this.cssPrefix}-duration">${s}</div>
                        ${i===this.playlist.currentIndex()?`<div class="${this.cssPrefix}-playing-badge">NOW PLAYING</div>`:""}
                    </div>
                    <div class="${this.cssPrefix}-item-details">
                        <div class="${this.cssPrefix}-item-title">${t.title||"Video "+(i+1)}</div>
                        <div class="${this.cssPrefix}-item-duration">${s}</div>
                    </div>
                </div>
            `),this.playlistGridElement.append(e)}),this.playlistItems[this.playlist.currentIndex()]&&this.updateVideoInfo(this.playlistItems[this.playlist.currentIndex()]))}updateVideoInfo(t){this.videoTitleElement&&this.videoTitleElement.text(t.title||"Video Title"),this.descriptionElement&&this.descriptionElement.find("p").text(t.description||"Video description")}setupEventListeners(){super.setupEventListeners(),this.$(`#${this.playlistId} .${this.cssPrefix}-playlist-item`).on("click",t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.setupSearchFunctionality(),this.gridViewBtn&&this.listViewBtn&&(this.gridViewBtn.on("click",()=>{this.playlistGridElement.removeClass("list-view"),this.gridViewBtn.addClass("active"),this.listViewBtn.removeClass("active")}),this.listViewBtn.on("click",()=>{this.playlistGridElement.addClass("list-view"),this.listViewBtn.addClass("active"),this.gridViewBtn.removeClass("active")}))}highlightActiveItem(t){if(t===-1||t===void 0)return;this.$(`#${this.playlistId} .${this.cssPrefix}-playlist-item`).removeClass("active"),this.$(`#${this.playlistId} .${this.cssPrefix}-playing-badge`).remove();const i=this.$(`#${this.playlistId} .${this.cssPrefix}-playlist-item[data-index="${t}"]`);if(i.length){i.addClass("active");const e=i.find(`.${this.cssPrefix}-item-thumbnail`);e.length&&this.$("<div>").addClass(`${this.cssPrefix}-playing-badge`).text("NOW PLAYING").appendTo(e);const s=this.playlistGridElement;if(s&&s.length){const r=i.position().top,l=i.outerHeight(),a=s.height(),o=s.scrollTop();(r<0||r+l>a)&&s.animate({scrollTop:o+r-a/2+l/2},200)}}this.playlistItems[t]&&this.updateVideoInfo(this.playlistItems[t])}injectStyles(){const t=`${this.cssPrefix}-styles`;if(document.getElementById(t))return;const i=this.config.themeMode==="dark",e=h.getColorPalette(this.config.themeMode),s={indigo:{primary:i?"#6366f1":"#4f46e5",primaryLight:i?"#818cf8":"#6366f1",primaryDark:i?"#4338ca":"#3730a3"},emerald:{primary:i?"#34d399":"#10b981",primaryLight:i?"#6ee7b7":"#34d399",primaryDark:i?"#059669":"#047857"},amber:{primary:i?"#fbbf24":"#f59e0b",primaryLight:i?"#fcd34d":"#fbbf24",primaryDark:i?"#d97706":"#b45309"},rose:{primary:i?"#fb7185":"#f43f5e",primaryLight:i?"#fda4af":"#fb7185",primaryDark:i?"#e11d48":"#be123c"}},r=s[this.config.colorTheme]||s.indigo;this.$(`<style id="${t}">
            /* Common styles from PlaylistUtils */
            ${h.getCommonStyles(this.cssPrefix,e)}
            
            /* Grid Video Playlist Theme with instance-specific selectors: ${this.cssPrefix} */
            .${this.cssPrefix}-wrapper {
                display: flex;
                flex-direction: column;
                width: 100%;
                gap: 24px;
            }
            
            /* Player section */
            .${this.cssPrefix}-player-section {
                display: flex;
                flex-direction: column;
                width: 100%;
                position: relative;
            }
            
            /* Video info section */
            .${this.cssPrefix}-info-section {
                padding: 0;
                margin-top: 16px;
                background: ${e.headerBg};
            }
            
            .${this.cssPrefix}-video-title {
                font-size: 22px;
                font-weight: 600;
                margin: 0 0 12px 0;
                line-height: 1.3;
                color: ${e.textColor};
                padding: 10px;
            }
            
            .${this.cssPrefix}-description {
                color: ${e.descriptionColor};
                font-size: 15px;
                line-height: 1.5;
                padding: 10px;
            }
            
            .${this.cssPrefix}-description p {
                margin: 0;
            }
            
            /* Playlist section */
            .${this.cssPrefix}-playlist-section {
                display: flex;
                flex-direction: column;
                width: 100%;
                gap: 12px;
                margin-top: 16px;
                padding: 1px;
                border: 1px solid ${e.borderColor};
                border-radius: 8px;
                background: ${i?"#2A2A2A":"#F8F8F8"};
            }
            
            /* Playlist header */
            .${this.cssPrefix}-playlist-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 12px;
            }
            
            .${this.cssPrefix}-view-controls {
                display: flex;
                gap: 8px;
            }
            
            .${this.cssPrefix}-grid-view-btn,
            .${this.cssPrefix}-list-view-btn {
                width: 32px;
                height: 32px;
                border-radius: 4px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: transparent;
                border: 1px solid ${e.borderColor};
                cursor: pointer;
                color: ${e.mutedTextColor};
                transition: all 0.2s;
                padding: 0;
            }
            
            .${this.cssPrefix}-grid-view-btn:hover,
            .${this.cssPrefix}-list-view-btn:hover {
                background: ${e.itemHoverBg};
                color: ${e.textColor};
            }
            
            .${this.cssPrefix}-grid-view-btn.active,
            .${this.cssPrefix}-list-view-btn.active {
                background: ${r.primaryLight};
                color: #FFFFFF;
                border-color: ${r.primary};
            }
            
            /* Playlist grid */
            .${this.cssPrefix}-playlist-grid {
                display: grid;
                grid-template-columns: repeat(${this.config.columnsDesktop}, 1fr);
                gap: 16px;
                width: 100%;
                max-height: 400px;
                overflow-y: auto;
                padding-right: 4px;
            }
            
            /* List view */
            .${this.cssPrefix}-playlist-grid.list-view {
                display: flex;
                flex-direction: column;
                gap: 12px;
            }
            
            .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-playlist-item {
                border-radius: 4px;
            }
            
            .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-inner {
                display: flex;
                align-items: center;
                flex-direction: row;
                border: 1px solid ${e.itemBorderColor};
                width: 100%;
            }
            
            .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-thumbnail {
                width: 120px;
                height: 68px;
                flex-shrink: 0;
                margin-bottom: 0;
                border-radius: 0;
                position: relative;
            }
            
            .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-details {
                padding: 8px 12px;
                flex: 1;
            }
            
            /* Playlist items */
            .${this.cssPrefix}-playlist-item {
                cursor: pointer;
                transition: transform 0.2s;
            }
            
            .${this.cssPrefix}-playlist-item:hover {
                transform: translateY(-2px);
            }
            
            .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-playlist-item:hover {
                transform: none;
            }
            
            .${this.cssPrefix}-playlist-item.active .${this.cssPrefix}-item-inner {
                background: ${e.itemActiveBg};
                border-color: ${r.primary};
            }
            
            .${this.cssPrefix}-item-inner {
                border-radius: 6px;
                overflow: hidden;
                border: 1px solid ${e.itemBorderColor};
                transition: all 0.2s;
                height: 100%;
                display: flex;
                flex-direction: column;
                background: ${e.bgColor};
            }
            
            .${this.cssPrefix}-playlist-item:hover .${this.cssPrefix}-item-inner {
                border-color: ${r.primaryLight};
                box-shadow: 0 2px 8px rgba(0, 0, 0, ${i?"0.3":"0.1"});
            }
            
            .${this.cssPrefix}-item-thumbnail {
                position: relative;
                width: 100%;
                aspect-ratio: 16 / 9;
                overflow: hidden;
                margin-bottom: 0;
                background: ${i?"#1A1A1A":"#F0F0F0"};
            }
            
            .${this.cssPrefix}-item-thumbnail img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.3s;
            }
            
            .${this.cssPrefix}-playlist-item:hover .${this.cssPrefix}-item-thumbnail img {
                transform: scale(1.05);
            }
            
            .${this.cssPrefix}-duration {
                position: absolute;
                bottom: 8px;
                right: 8px;
                background: rgba(0, 0, 0, 0.7);
                color: white;
                font-size: 12px;
                font-weight: 500;
                padding: 2px 6px;
                border-radius: 3px;
                z-index: 2;
            }
            
            .${this.cssPrefix}-playing-badge {
                position: absolute;
                top: 8px;
                left: 8px;
                background: ${e.nowPlayingBg};
                color: white;
                font-size: 10px;
                font-weight: 600;
                padding: 2px 6px;
                border-radius: 3px;
                z-index: 2;
            }
            
            .${this.cssPrefix}-item-details {
                display: flex;
                flex-direction: column;
                gap: 6px;
                padding: 12px;
                flex-grow: 1;
            }
            
            .${this.cssPrefix}-item-title {
                font-size: 14px;
                font-weight: 500;
                line-height: 1.4;
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
                overflow: hidden;
                color: ${e.textColor};
                margin-bottom: 4px;
            }
            
            .${this.cssPrefix}-item-duration {
                font-size: 12px;
                color: ${e.mutedTextColor};
            }
            
            /* Responsive adjustments */
            @media (max-width: 1024px) {
                .${this.cssPrefix}-playlist-grid {
                    grid-template-columns: repeat(${this.config.columnsTablet}, 1fr);
                }
            }
            
            @media (max-width: 768px) {
                .${this.cssPrefix}-playlist-grid {
                    grid-template-columns: repeat(${this.config.columnsMobile}, 1fr);
                }
                
                .${this.cssPrefix}-playlist-header {
                    flex-direction: row;
                    justify-content: space-between;
                    align-items: center;
                    gap: 12px;
                }
                
                .${this.cssPrefix}-search-box {
                    width: auto;
                    max-width: 60%;
                }
                
                .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-inner {
                    flex-direction: column;
                }
                
                .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-thumbnail {
                    width: 100%;
                    height: auto;
                    aspect-ratio: 16 / 9;
                }
                
                .${this.cssPrefix}-playlist-grid.list-view .${this.cssPrefix}-item-details {
                    width: 100%;
                    padding: 12px;
                }
            }
            
            @media (max-width: 480px) {
                .${this.cssPrefix}-item-thumbnail {
                    aspect-ratio: 16 / 10;
                }
                
                .${this.cssPrefix}-item-title {
                    font-size: 13px;
                }
            }
        </style>`).appendTo("head")}}class b extends d{constructor(t){super(t),this.config={...this.config,progressColor:this.playlistModel.progressColor||"#14b8a6",timelineColor:this.playlistModel.timelineColor||"#d1d5db"},this.chapterView=!1,this.timelineContainer=null,this.timelineViewBtn=null,this.chapterViewBtn=null}createLayout(){const t=this.$("<div>").addClass(`${this.cssPrefix}-wrapper`).attr("id",`${this.instance}_timeline_wrapper`),i=this.$("<div>").addClass(`${this.cssPrefix}-player-section`),e=this.$(`#${this.instance}`);this.playlistSection=this.$("<div>").addClass(`${this.cssPrefix}-timeline-section`).attr("id",`${this.instance}_timeline_section`);const s=this.$("<div>").addClass(`${this.cssPrefix}-timeline-header`);this.$("<h3>").addClass(`${this.cssPrefix}-timeline-title`).text(this.playlistModel.title||"Video Course").appendTo(s);const r=this.$("<div>").addClass(`${this.cssPrefix}-timeline-controls`).appendTo(s),l=this.$("<div>").addClass(`${this.cssPrefix}-view-controls`).html(`
                <button class="${this.cssPrefix}-timeline-view-btn active" aria-label="Timeline View" title="Timeline View">
                    <svg viewBox="0 0 24 24" width="20" height="20" stroke="currentColor" stroke-width="2" fill="none">
                        <line x1="3" y1="12" x2="21" y2="12"></line>
                        <circle cx="8" cy="12" r="2"></circle>
                        <circle cx="16" cy="12" r="2"></circle>
                    </svg>
                </button>
                <button class="${this.cssPrefix}-chapter-view-btn" aria-label="Chapter View" title="Chapter View">
                    <svg viewBox="0 0 24 24" width="20" height="20" stroke="currentColor" stroke-width="2" fill="none">
                        <line x1="8" y1="6" x2="21" y2="6"></line>
                        <line x1="8" y1="12" x2="21" y2="12"></line>
                        <line x1="8" y1="18" x2="21" y2="18"></line>
                        <line x1="3" y1="6" x2="3.01" y2="6"></line>
                        <line x1="3" y1="12" x2="3.01" y2="12"></line>
                        <line x1="3" y1="18" x2="3.01" y2="18"></line>
                    </svg>
                </button>
            `).appendTo(r);if(this.playlistSection.append(s),this.config.showSearch!==!1){const a=this.createSearchBox(this.playlistSection);this.chapterView||a.hide()}this.timelineContainer=this.$("<div>").addClass(`${this.cssPrefix}-timeline-container`).attr("id",`${this.playlistId}`).appendTo(this.playlistSection),this.playlistContainer=this.playlistSection,e.length&&i.append(e),t.append(i),t.append(this.playlistSection),this.$(this.container).empty().append(t),this.timelineViewBtn=l.find(`.${this.cssPrefix}-timeline-view-btn`),this.chapterViewBtn=l.find(`.${this.cssPrefix}-chapter-view-btn`)}renderPlaylistItems(){!this.timelineContainer||!this.playlistItems.length||(this.timelineContainer.empty(),this.chapterView?(this.renderChapterView(),this.$(`.${this.cssPrefix}-search-box`).show()):(this.renderTimelineView(),this.$(`.${this.cssPrefix}-search-box`).hide()),this.playlistItems[this.playlist.currentIndex()])}renderTimelineView(){const t=this.playlist.currentIndex(),i=this.$("<div>").addClass(`${this.cssPrefix}-timeline-wrapper`),e=this.$("<div>").addClass(`${this.cssPrefix}-timeline-track`).appendTo(i);this.$("<div>").addClass(`${this.cssPrefix}-progress-bar`).css("width",`${t/(this.playlistItems.length-1)*100}%`).appendTo(e),this.playlistItems.forEach((r,l)=>{const a=this.$("<div>").addClass(`${this.cssPrefix}-timeline-node`).attr("data-index",l).css("left",`${l/(this.playlistItems.length-1)*100}%`);l<t?a.addClass("completed"):l===t?a.addClass("current"):a.addClass("upcoming"),this.$("<div>").addClass(`${this.cssPrefix}-node-tooltip`).html(`
                    <div class="${this.cssPrefix}-tooltip-content">
                        <div class="${this.cssPrefix}-tooltip-title">${r.title||`Video ${l+1}`}</div>
                        <div class="${this.cssPrefix}-tooltip-duration">${r.duration||"00:00"}</div>
                    </div>
                `).appendTo(a),i.append(a)}),this.timelineContainer.append(i);const s=this.$("<div>").addClass(`${this.cssPrefix}-video-list`);for(let r=t;r<Math.min(t+4,this.playlistItems.length);r++){const l=this.playlistItems[r],a=this.$("<div>").addClass(`${this.cssPrefix}-video-item`).attr("data-index",r);r===t&&a.addClass("current");const o=l.duration||"00:00";a.html(`
                <div class="${this.cssPrefix}-video-item-status">
                    ${r===t?`<div class="${this.cssPrefix}-now-playing-badge">NOW</div>`:`<div class="${this.cssPrefix}-item-number">${r+1}</div>`}
                </div>
                <div class="${this.cssPrefix}-video-item-content">
                    <div class="${this.cssPrefix}-video-item-thumbnail">
                        <img src="${l.poster||""}" alt="Video thumbnail">
                        <div class="${this.cssPrefix}-duration">${o}</div>
                    </div>
                    <div class="${this.cssPrefix}-video-item-details">
                        <div class="${this.cssPrefix}-video-item-title">${l.title||`Video ${r+1}`}</div>
                        <div class="${this.cssPrefix}-video-item-meta">
                            <span>${l.updated_at||l.created_at||""}</span>
                        </div>
                    </div>
                </div>
            `),s.append(a)}if(t+4<this.playlistItems.length){const r=this.$("<div>").addClass(`${this.cssPrefix}-view-all-btn`).html(`
                    <span>View All ${this.playlistItems.length} Videos</span>
                    <svg viewBox="0 0 24 24" width="16" height="16" stroke="currentColor" stroke-width="2" fill="none">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                `);s.append(r)}this.timelineContainer.append(s)}renderChapterView(){const t=this.playlist.currentIndex(),i=this.$("<div>").addClass(`${this.cssPrefix}-chapter-list`);this.playlistItems.forEach((e,s)=>{const r=this.$("<div>").addClass(`${this.cssPrefix}-chapter-item`).attr("data-index",s);s===t?r.addClass("current"):s<t&&r.addClass("completed");const l=e.duration||"00:00";let a="";s===t?a=`<div class="${this.cssPrefix}-status-badge current">Now Playing</div>`:s<t?a=`<div class="${this.cssPrefix}-status-badge completed">Completed</div>`:s===t+1&&(a=`<div class="${this.cssPrefix}-status-badge next">Up Next</div>`),r.html(`
                <div class="${this.cssPrefix}-chapter-number">${s+1}</div>
                <div class="${this.cssPrefix}-chapter-content">
                    <div class="${this.cssPrefix}-chapter-thumbnail">
                        <img src="${e.poster||""}" alt="Video thumbnail">
                        <div class="${this.cssPrefix}-chapter-duration">${l}</div>
                    </div>
                    <div class="${this.cssPrefix}-chapter-details">
                        <div class="${this.cssPrefix}-chapter-title">${e.title||`Video ${s+1}`}</div>
                        <div class="${this.cssPrefix}-chapter-meta">
                            <span>${e.updated_at||e.created_at||""}</span>
                            ${a}
                        </div>
                    </div>
                </div>
            `),i.append(r)}),this.timelineContainer.append(i)}updateViewButtons(){this.timelineViewBtn&&this.chapterViewBtn&&(this.chapterView?(this.timelineViewBtn.removeClass("active"),this.chapterViewBtn.addClass("active"),this.$(`.${this.cssPrefix}-search-box`).show()):(this.timelineViewBtn.addClass("active"),this.chapterViewBtn.removeClass("active"),this.$(`.${this.cssPrefix}-search-box`).hide()))}highlightActiveItem(t){if(!(t===-1||t===void 0))if(this.chapterView)this.timelineContainer.find(`.${this.cssPrefix}-chapter-item`).each((e,s)=>{const r=this.$(s),l=parseInt(r.data("index"));r.removeClass("current completed"),l===t?r.addClass("current"):l<t&&r.addClass("completed");const a=r.find(`.${this.cssPrefix}-chapter-meta`);a.length&&(a.find(`.${this.cssPrefix}-status-badge`).remove(),l===t?a.append(`<div class="${this.cssPrefix}-status-badge current">Now Playing</div>`):l<t?a.append(`<div class="${this.cssPrefix}-status-badge completed">Completed</div>`):l===t+1&&a.append(`<div class="${this.cssPrefix}-status-badge next">Up Next</div>`))});else{this.timelineContainer.find(`.${this.cssPrefix}-timeline-node`).each((s,r)=>{const l=this.$(r),a=parseInt(l.data("index"));l.removeClass("completed current upcoming"),a<t?l.addClass("completed"):a===t?l.addClass("current"):l.addClass("upcoming")});const e=this.timelineContainer.find(`.${this.cssPrefix}-progress-bar`);e.length&&e.css("width",`${t/(this.playlistItems.length-1)*100}%`),this.renderPlaylistItems()}}setupEventListeners(){super.setupEventListeners(),this.timelineContainer.on("click",`.${this.cssPrefix}-timeline-node`,t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.timelineContainer.on("click",`.${this.cssPrefix}-video-item`,t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.timelineContainer.on("click",`.${this.cssPrefix}-chapter-item`,t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.timelineContainer.on("click",`.${this.cssPrefix}-view-all-btn`,()=>{this.chapterView=!0,this.updateViewButtons(),this.renderPlaylistItems()}),this.timelineViewBtn&&this.timelineViewBtn.on("click",()=>{this.chapterView=!1,this.updateViewButtons(),this.renderPlaylistItems()}),this.chapterViewBtn&&this.chapterViewBtn.on("click",()=>{this.chapterView=!0,this.updateViewButtons(),this.renderPlaylistItems()}),this.setupSearchFunctionality()}injectStyles(){const t=`${this.cssPrefix}-styles`;if(document.getElementById(t))return;const i=h.getColorPalette(this.config.themeMode),e=this.config.progressColor,s=this.config.timelineColor;this.$(`<style id="${t}">
            /* Common styles from PlaylistUtils */
            ${h.getCommonStyles(this.cssPrefix,i)}
            
            /* Timeline Video Playlist Theme with instance-specific selectors: ${this.cssPrefix} */
            
            /* Main layout */
            .${this.cssPrefix}-wrapper {
                display: flex;
                flex-direction: column;
                width: 100%;
                gap: 32px;
                color: ${i.textColor};
            }
            
            /* Player section */
            .${this.cssPrefix}-player-section {
                display: flex;
                flex-direction: column;
                position: relative;
            }
            
            /* Timeline section */
            .${this.cssPrefix}-timeline-section {
                display: flex;
                flex-direction: column;
                gap: 24px;
                border-radius: 12px;
                background-color: ${i.bgColor};
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
                width: 95%;
                padding: 15px;
            }
            
            /* Timeline header */
            .${this.cssPrefix}-timeline-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            
            .${this.cssPrefix}-timeline-title {
                font-size: 18px;
                font-weight: 700;
                margin: 0;
                color: ${i.textColor};
            }
            
            .${this.cssPrefix}-timeline-controls {
                display: flex;
                align-items: center;
                gap: 16px;
            }
            
            .${this.cssPrefix}-view-controls {
                display: flex;
                gap: 8px;
            }
            
            .${this.cssPrefix}-timeline-view-btn,
            .${this.cssPrefix}-chapter-view-btn {
                width: 34px;
                height: 34px;
                border-radius: 6px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: transparent;
                border: 1px solid ${i.borderColor};
                cursor: pointer;
                color: ${i.mutedTextColor};
                transition: all 0.2s;
                padding: 0;
            }
            
            .${this.cssPrefix}-timeline-view-btn:hover,
            .${this.cssPrefix}-chapter-view-btn:hover {
                background: ${i.itemHoverBg};
            }
            
            .${this.cssPrefix}-timeline-view-btn.active,
            .${this.cssPrefix}-chapter-view-btn.active {
                color: ${e};
                border-color: ${e};
            }
            
            /* Timeline view */
            .${this.cssPrefix}-timeline-wrapper {
                position: relative;
                margin: 50px 0;
                padding: 0 16px;
            }
            
            .${this.cssPrefix}-timeline-track {
                position: relative;
                height: 4px;
                background-color: ${s};
                border-radius: 2px;
            }
            
            .${this.cssPrefix}-progress-bar {
                position: absolute;
                top: 0;
                left: 0;
                height: 100%;
                background-color: ${e};
                border-radius: 2px;
                transition: width 0.3s ease;
            }
            
            .${this.cssPrefix}-timeline-node {
                position: absolute;
                width: 16px;
                height: 16px;
                border-radius: 50%;
                top: -6px;
                transform: translateX(-8px);
                cursor: pointer;
                z-index: 1;
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
                transition: all 0.2s ease;
            }
            
            .${this.cssPrefix}-timeline-node.completed {
                background-color: ${e};
                border: 2px solid ${e};
            }
            
            .${this.cssPrefix}-timeline-node.current {
                background-color: white;
                border: 3px solid ${e};
                width: 20px;
                height: 20px;
                top: -8px;
                transform: translateX(-10px);
            }
            
            .${this.cssPrefix}-timeline-node.upcoming {
                background-color: white;
                border: 2px solid ${s};
            }
            
            .${this.cssPrefix}-timeline-node:hover {
                transform: translateX(-8px) scale(1.2);
            }
            
            .${this.cssPrefix}-timeline-node.current:hover {
                transform: translateX(-10px) scale(1.2);
            }
            
            .${this.cssPrefix}-node-tooltip {
                position: absolute;
                bottom: 30px;
                left: 50%;
                transform: translateX(-50%);
                opacity: 0;
                visibility: hidden;
                transition: all 0.2s ease;
                width: 200px;
                pointer-events: none;
            }
            
            .${this.cssPrefix}-timeline-node:hover .${this.cssPrefix}-node-tooltip {
                opacity: 1;
                visibility: visible;
                bottom: 25px;
            }
            .${this.cssPrefix}-tooltip-content {
                background-color: ${i.bgColor};
                border: 1px solid ${i.borderColor};
                border-radius: 6px;
                padding: 8px 12px;
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            }
            
            .${this.cssPrefix}-tooltip-title {
                font-size: 14px;
                font-weight: 500;
                margin-bottom: 4px;
                line-height: 1.3;
            }
            
            .${this.cssPrefix}-tooltip-duration {
                font-size: 12px;
                color: ${i.mutedTextColor};
            }
            
            /* Video list below timeline */
            .${this.cssPrefix}-video-list {
                margin-top: 40px;
                display: flex;
                flex-direction: column;
                gap: 16px;
            }
            
            .${this.cssPrefix}-video-item {
                display: flex;
                gap: 16px;
                padding: 16px;
                border-radius: 8px;
                background-color: ${i.bgColor};
                border: 1px solid ${i.borderColor};
                transition: all 0.2s ease;
                cursor: pointer;
            }
            
            .${this.cssPrefix}-video-item:hover {
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                border-color: ${i.mutedTextColor};
            }
            
            .${this.cssPrefix}-video-item.current {
                border-color: ${e};
                background-color: ${e}11;
            }
            
            .${this.cssPrefix}-video-item-status {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 40px;
                flex-shrink: 0;
            }
            
            .${this.cssPrefix}-now-playing-badge {
                background-color: ${e};
                color: white;
                font-size: 10px;
                font-weight: 600;
                padding: 3px 6px;
                border-radius: 4px;
                letter-spacing: 0.5px;
            }
            
            .${this.cssPrefix}-item-number {
                width: 28px;
                height: 28px;
                border-radius: 50%;
                background-color: ${i.itemHoverBg};
                color: ${i.mutedTextColor};
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 14px;
                font-weight: 600;
            }
            
            .${this.cssPrefix}-video-item-content {
                display: flex;
                gap: 16px;
                flex: 1;
            }
            
            .${this.cssPrefix}-video-item-thumbnail {
                width: 120px;
                height: 68px;
                border-radius: 6px;
                overflow: hidden;
                position: relative;
                flex-shrink: 0;
                background-color: ${i.borderColor};
            }
            
            .${this.cssPrefix}-video-item-thumbnail img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            
            .${this.cssPrefix}-duration {
                position: absolute;
                bottom: 4px;
                right: 4px;
                background-color: rgba(0, 0, 0, 0.7);
                color: white;
                font-size: 11px;
                padding: 2px 4px;
                border-radius: 2px;
            }
            
            .${this.cssPrefix}-video-item-details {
                flex: 1;
                min-width: 0;
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
            
            .${this.cssPrefix}-video-item-title {
                font-size: 15px;
                font-weight: 600;
                margin-bottom: 5px;
                line-height: 1.3;
            }
            
            .${this.cssPrefix}-video-item-meta {
                color: ${i.mutedTextColor};
                font-size: 13px;
            }
            
            .${this.cssPrefix}-view-all-btn {
                margin-top: 8px;
                padding: 12px 16px;
                text-align: center;
                background-color: ${i.bgColor};
                border: 1px solid ${i.borderColor};
                border-radius: 8px;
                cursor: pointer;
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 8px;
                font-size: 14px;
                font-weight: 500;
                color: ${i.textColor};
                transition: all 0.2s ease;
            }
            
            .${this.cssPrefix}-view-all-btn:hover {
                background-color: ${i.itemHoverBg};
            }
            
            /* Chapter view */
            .${this.cssPrefix}-chapter-list {
                display: flex;
                flex-direction: column;
                gap: 10px;
            }
            
            .${this.cssPrefix}-chapter-item {
                display: flex;
                gap: 16px;
                padding: 16px;
                border-radius: 8px;
                background-color: ${i.bgColor};
                border: 1px solid ${i.borderColor};
                transition: all 0.2s ease;
                cursor: pointer;
                position: relative;
            }
            
            .${this.cssPrefix}-chapter-item:hover {
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                border-color: ${i.mutedTextColor};
            }
            
            .${this.cssPrefix}-chapter-item.current {
                border-color: ${e};
                background-color: ${e}11;
            }
            
            .${this.cssPrefix}-chapter-item.completed {
                border-left: 4px solid ${e};
            }
            
            .${this.cssPrefix}-chapter-number {
                width: 32px;
                height: 32px;
                border-radius: 50%;
                background-color: ${i.itemHoverBg};
                color: ${i.mutedTextColor};
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 14px;
                font-weight: 600;
                flex-shrink: 0;
            }
            
            .${this.cssPrefix}-chapter-item.current .${this.cssPrefix}-chapter-number {
                background-color: ${e};
                color: white;
            }
            
            .${this.cssPrefix}-chapter-content {
                display: flex;
                gap: 16px;
                flex: 1;
            }
            
            .${this.cssPrefix}-chapter-thumbnail {
                width: 120px;
                height: 68px;
                border-radius: 6px;
                overflow: hidden;
                position: relative;
                flex-shrink: 0;
                background-color: ${i.borderColor};
            }
            
            .${this.cssPrefix}-chapter-thumbnail img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            
            .${this.cssPrefix}-chapter-duration {
                position: absolute;
                bottom: 4px;
                right: 4px;
                background-color: rgba(0, 0, 0, 0.7);
                color: white;
                font-size: 11px;
                padding: 2px 4px;
                border-radius: 2px;
            }
            
            .${this.cssPrefix}-chapter-details {
                flex: 1;
                min-width: 0;
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
            
            .${this.cssPrefix}-chapter-title {
                font-size: 16px;
                font-weight: 600;
                margin-bottom: 6px;
                line-height: 1.3;
            }
            
            .${this.cssPrefix}-chapter-meta {
                color: ${i.mutedTextColor};
                font-size: 13px;
                display: flex;
                align-items: center;
                gap: 12px;
            }
            
            .${this.cssPrefix}-status-badge {
                font-size: 11px;
                font-weight: 600;
                padding: 2px 8px;
                border-radius: 4px;
            }
            
            .${this.cssPrefix}-status-badge.current {
                background-color: ${e};
                color: white;
            }
            
            .${this.cssPrefix}-status-badge.completed {
                background-color: ${e}22;
                color: ${e};
            }
            
            .${this.cssPrefix}-status-badge.next {
                background-color: ${i.mutedTextColor}22;
                color: ${i.mutedTextColor};
            }
            
            /* Responsive layout */
            @media (max-width: 768px) {
                .${this.cssPrefix}-timeline-header {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 12px;
                }
                
                .${this.cssPrefix}-timeline-controls {
                    width: 100%;
                    justify-content: space-between;
                }
                
                .${this.cssPrefix}-video-item-content {
                    flex-direction: column;
                }
                
                .${this.cssPrefix}-video-item-thumbnail {
                    width: 100%;
                    height: auto;
                    aspect-ratio: 16/9;
                }
                
                .${this.cssPrefix}-chapter-content {
                    flex-direction: column;
                }
                
                .${this.cssPrefix}-chapter-thumbnail {
                    width: 100%;
                    height: auto;
                    aspect-ratio: 16/9;
                }
            }
            
            @media (max-width: 480px) {
                .${this.cssPrefix}-timeline-section {
                    padding: 16px;
                }
                
                .${this.cssPrefix}-video-item {
                    padding: 12px;
                }
                
                .${this.cssPrefix}-chapter-item {
                    padding: 12px;
                }
            }
        </style>`).appendTo("head")}}class v extends d{constructor(t){super(t),this.config={...this.config,accentColor:this.playlistModel.accentColor||"#10b981"},this.playlistScrollContainer=null,this.prevButton=null,this.nextButton=null,this.playlistTitleElement=null,this.playlistDescriptionElement=null}createLayout(){const t=this.$("<div>").addClass(`${this.cssPrefix}-wrapper`).attr("id",`${this.instance}_horizontal_wrapper`),i=this.$("<div>").addClass(`${this.cssPrefix}-player-section`),e=this.$(`#${this.instance}`);this.playlistSection=this.$("<div>").addClass(`${this.cssPrefix}-playlist-section`).attr("id",`${this.instance}_playlist_section`);const s=this.$("<div>").addClass(`${this.cssPrefix}-playlist-header`),r=this.$("<div>").addClass(`${this.cssPrefix}-playlist-controls`).appendTo(s);this.createSearchBox(r);const l=this.$("<div>").addClass(`${this.cssPrefix}-nav-arrows`).html(`
                <button class="${this.cssPrefix}-prev-btn" aria-label="Previous">
                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none">
                        <polyline points="15 18 9 12 15 6"></polyline>
                    </svg>
                </button>
                <button class="${this.cssPrefix}-next-btn" aria-label="Next">
                    <svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </button>
            `).appendTo(r);this.playlistSection.append(s),this.playlistContainer=this.$("<div>").addClass(`${this.cssPrefix}-playlist-container`).attr("id",`${this.playlistId}`).appendTo(this.playlistSection),this.playlistScrollContainer=this.$("<div>").addClass(`${this.cssPrefix}-playlist-scroll`).appendTo(this.playlistContainer);const a=this.$("<div>").addClass(`${this.cssPrefix}-playlist-info`);this.config.showTitle!==!1&&(this.playlistTitleElement=this.$("<h2>").addClass(`${this.cssPrefix}-playlist-title-display`).text(this.playlistModel.title||"Video Playlist").appendTo(a)),this.config.showDescription!==!1&&(this.playlistDescriptionElement=this.$("<div>").addClass(`${this.cssPrefix}-playlist-description`).html(`<p>${this.playlistModel.description||"No description available"}</p>`).appendTo(a)),e.length&&i.append(e),t.append(i),t.append(this.playlistSection),t.append(a),this.$(this.container).empty().append(t),this.prevButton=l.find(`.${this.cssPrefix}-prev-btn`),this.nextButton=l.find(`.${this.cssPrefix}-next-btn`)}renderPlaylistItems(){!this.playlistScrollContainer||!this.playlistItems.length||(this.playlistScrollContainer.empty(),this.playlistItems.forEach((t,i)=>{const e=this.$("<div>").addClass(`${this.cssPrefix}-playlist-item`).attr("data-index",i);i===this.playlist.currentIndex()&&e.addClass("active");const s=t.duration||"00:00";e.html(`
                <div class="${this.cssPrefix}-item-thumbnail">
                    <img src="${t.poster||""}" alt="Video thumbnail">
                    <div class="${this.cssPrefix}-duration">${s}</div>
                    ${i===this.playlist.currentIndex()?`<div class="${this.cssPrefix}-playing-badge">NOW PLAYING</div>`:""}
                </div>
                <div class="${this.cssPrefix}-item-details">
                    <div class="${this.cssPrefix}-item-title">${t.title||`Video ${i+1}`}</div>
                    <div class="${this.cssPrefix}-item-meta">
                        <span>${t.updated_at||t.created_at||""}</span>
                    </div>
                </div>
            `),this.playlistScrollContainer.append(e)}))}highlightActiveItem(t){if(t===-1||t===void 0)return;this.$(`#${this.playlistId} .${this.cssPrefix}-playlist-item`).removeClass("active"),this.$(`#${this.playlistId} .${this.cssPrefix}-playing-badge`).remove();const i=this.$(`#${this.playlistId} .${this.cssPrefix}-playlist-item[data-index="${t}"]`);if(i.length){i.addClass("active");const e=i.find(`.${this.cssPrefix}-item-thumbnail`);e.length&&this.$("<div>").addClass(`${this.cssPrefix}-playing-badge`).text("NOW PLAYING").appendTo(e),this.scrollItemIntoView(i)}}scrollItemIntoView(t){if(!t||!t.length||!this.playlistScrollContainer)return;const i=this.playlistScrollContainer.width(),e=t.outerWidth(),s=t.position().left,r=this.playlistScrollContainer.scrollLeft(),l=s+e,a=i;(s<0||l>a)&&this.playlistScrollContainer.animate({scrollLeft:r+s-(i-e)/2},300)}scrollPlaylist(t){if(!this.playlistScrollContainer)return;const i=this.playlistScrollContainer.width()*.8,e=this.playlistScrollContainer.scrollLeft();t==="left"?this.playlistScrollContainer.animate({scrollLeft:e-i},300):this.playlistScrollContainer.animate({scrollLeft:e+i},300)}setupEventListeners(){super.setupEventListeners(),this.playlistScrollContainer.on("click",`.${this.cssPrefix}-playlist-item`,t=>{const i=parseInt(this.$(t.currentTarget).data("index"));this.playlist.currentItem(i),this.player.play(),this.highlightActiveItem(i)}),this.prevButton&&this.prevButton.on("click",()=>{this.scrollPlaylist("left")}),this.nextButton&&this.nextButton.on("click",()=>{this.scrollPlaylist("right")}),this.setupSearchFunctionality()}injectStyles(){const t=`${this.cssPrefix}-styles`;if(document.getElementById(t))return;const i=h.getColorPalette(this.config.themeMode,this.config.accentColor);this.$(`<style id="${t}">
            /* Common styles from PlaylistUtils */
            ${h.getCommonStyles(this.cssPrefix,i)}
            
            /* Horizontal Video Playlist Theme with instance-specific selectors: ${this.cssPrefix} */
            
            /* Main layout */
            .${this.cssPrefix}-wrapper {
                display: flex;
                flex-direction: column;
                width: 100%;
                background-color: ${i.bgColor};
                color: ${i.textColor};
            }
            
            /* Player section */
            .${this.cssPrefix}-player-section {
                display: flex;
                flex-direction: column;
                width: 100%;
                position: relative;
            }
            
            /* Playlist section */
            .${this.cssPrefix}-playlist-section {
                display: flex;
                flex-direction: column;
                width: 100%;
                margin: 10px 0;
            }
            
            /* Playlist header */
            .${this.cssPrefix}-playlist-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 16px;
            }
            
            .${this.cssPrefix}-playlist-controls {
                display: flex;
                align-items: center;
                justify-content: space-between;
                width: 100%;
            }
            
            .${this.cssPrefix}-nav-arrows {
                display: flex;
                gap: 8px;
            }
            
            .${this.cssPrefix}-prev-btn,
            .${this.cssPrefix}-next-btn {
                width: 36px;
                height: 36px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                background: ${i.itemHoverBg};
                border: none;
                cursor: pointer;
                color: ${i.textColor};
                transition: background 0.2s, transform 0.2s;
                padding: 0;
            }
            
            .${this.cssPrefix}-prev-btn:hover,
            .${this.cssPrefix}-next-btn:hover {
                background: ${i.borderColor};
                transform: scale(1.05);
            }
            
            .${this.cssPrefix}-prev-btn svg,
            .${this.cssPrefix}-next-btn svg {
                width: 18px;
                height: 18px;
            }
            
            /* Playlist container */
            .${this.cssPrefix}-playlist-container {
                position: relative;
                width: 100%;
                overflow: hidden;
                border-radius: 8px;
            }
            
            .${this.cssPrefix}-playlist-scroll {
                display: flex;
                gap: 16px;
                padding: 4px 4px 16px 4px;
                overflow-x: auto;
                scrollbar-width: thin;
                scrollbar-color: ${i.borderColor} transparent;
            }
            
            /* Playlist items */
            .${this.cssPrefix}-playlist-item {
                flex: 0 0 auto;
                width: 280px;
                cursor: pointer;
                transition: transform 0.2s;
                display: flex;
                flex-direction: column;
                gap: 10px;
                overflow: hidden;
                border-radius: 8px;
                padding: 0;
            }
            
            .${this.cssPrefix}-playlist-item:hover {
                transform: translateY(-4px);
            }
            
            .${this.cssPrefix}-playlist-item.active {
                box-shadow: 0 0 0 2px ${this.config.accentColor};
            }
            
            .${this.cssPrefix}-item-thumbnail {
                position: relative;
                width: 100%;
                aspect-ratio: 16 / 9;
                border-radius: 8px;
                overflow: hidden;
                background: #000;
            }
            
            .${this.cssPrefix}-item-thumbnail img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.3s;
            }
            
            .${this.cssPrefix}-playlist-item:hover .${this.cssPrefix}-item-thumbnail img {
                transform: scale(1.05);
            }
            
            .${this.cssPrefix}-duration {
                position: absolute;
                bottom: 8px;
                right: 8px;
                background: rgba(0, 0, 0, 0.7);
                color: white;
                font-size: 12px;
                font-weight: 500;
                padding: 2px 6px;
                border-radius: 4px;
                z-index: 2;
            }
            
            .${this.cssPrefix}-playing-badge {
                position: absolute;
                top: 8px;
                left: 8px;
                background: ${this.config.accentColor};
                color: white;
                font-size: 10px;
                font-weight: 600;
                padding: 2px 8px;
                border-radius: 4px;
                z-index: 2;
            }
            
            .${this.cssPrefix}-item-details {
                display: flex;
                flex-direction: column;
                gap: 6px;
                padding: 6px 4px;
            }
            
            .${this.cssPrefix}-item-title {
                font-size: 15px;
                font-weight: 500;
                line-height: 1.3;
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
                overflow: hidden;
                color: ${i.textColor};
            }
            
            .${this.cssPrefix}-item-meta {
                display: flex;
                gap: 8px;
                font-size: 13px;
                color: ${i.mutedTextColor};
            }
            
            /* Playlist info section */
            .${this.cssPrefix}-playlist-info {
                
            }
            
            .${this.cssPrefix}-playlist-title-display {
                font-size: 22px;
                font-weight: 600;
                margin: 0 0 12px 0;
                color: ${i.textColor};
                padding: 10px;
            }
            
            .${this.cssPrefix}-playlist-description {
                font-size: 15px;
                line-height: 1.5;
                color: ${i.mutedTextColor};
                padding: 10px;
            }
            
            .${this.cssPrefix}-playlist-description p {
                margin: 0;
            }
            
            /* Responsive adjustments */
            @media (max-width: 768px) {
                .${this.cssPrefix}-playlist-item {
                    width: 220px;
                }
                
                .${this.cssPrefix}-playlist-title-display {
                    font-size: 20px;
                }
                
                .${this.cssPrefix}-search-box {
                    width: 50%;
                }
            }
            
            @media (max-width: 480px) {
                .${this.cssPrefix}-playlist-item {
                    width: 180px;
                }
                
                .${this.cssPrefix}-playlist-controls {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 12px;
                }
                
                .${this.cssPrefix}-search-box {
                    width: 100%;
                    max-width: 100%;
                    margin-bottom: 8px;
                }
                
                .${this.cssPrefix}-nav-arrows {
                    align-self: flex-end;
                }
            }
        </style>`).appendTo("head")}}class k{static getTheme(t){var a,o,c;const{playlistModel:i}=t,e=((o=(a=i.meta)==null?void 0:a.config)==null?void 0:o.layout)||"default",s=i.type,r={video:{default:u,grid:$,timeline:b,horizontal:v},audio:{default:u,grid:$,timeline:b,horizontal:v}},l=((c=r[s])==null?void 0:c[e])||r[s].default;return new l(t)}}class P{constructor(t){this.playlistModel=t,this.player=null,this.playlistMedia=[],this.playlist=null,this.checkPro(),this.theme=null}init(){this.getPlaylistItems().then(()=>{this.initPlayer(),this.initPlaylist(this.getFormattedPlaylistItems()),this.renderTheme()})}initPlayer(){var e;const t=((e=this.playlistModel.meta)==null?void 0:e.playerConfig)||{fluid:!0,controls:!0,autoplay:!1,preload:"auto",responsive:!0,audioOnlyMode:this.playlistModel.type==="audio"},i=new C(t,this.playlistModel).init();this.player=i.playerInstance.player}initPlaylist(t){var s;const i=((s=this.playlistModel.meta)==null?void 0:s.config)||{},e={autoPlay:(i==null?void 0:i.autoPlay)||!1,repeat:(i==null?void 0:i.repeat)||!1,shuffle:(i==null?void 0:i.shuffle)||!1,autoPlayDelay:0,maxItems:0,allowedTypes:[]};this.playlist=new I(this.player,t,e)}getFormattedPlaylistItems(){return this.playlistMedia.map(t=>{var i,e,s;return{title:t.title,description:t.description,sources:t.meta.config.sources,poster:((i=t==null?void 0:t.image)==null?void 0:i.url)||((e=t.meta.config)==null?void 0:e.poster),duration:((s=t.meta.config)==null?void 0:s._formattedDuration)||"00",meta:t.meta}})}renderTheme(){const t={player:this.player,playlist:this.playlist,playlistItems:this.getFormattedPlaylistItems(),playlistModel:this.playlistModel};this.theme=k.getTheme(t),this.theme.render()}async getPlaylistItems(){try{const t=await w.get(`playlists/${this.playlistModel.id}/media`);this.playlistMedia=t.data.data}catch(t){console.error(t)}}checkPro(){var s,r,l,a,o,c,p,f,x,m,g,y;const t=(autoCraftPlayerInfo==null?void 0:autoCraftPlayerInfo.pro_version)||!1;["grid","timeline","horizontal"].includes((r=(s=this.playlistModel.meta)==null?void 0:s.config)==null?void 0:r.layout)&&!t&&(this.playlistModel.meta.config.layout="default"),["dark","sepia","highContrast"].includes((a=(l=this.playlistModel.meta)==null?void 0:l.config)==null?void 0:a.themeMode)&&!t&&(this.playlistModel.meta.config.themeMode="light"),(c=(o=this.playlistModel.meta)==null?void 0:o.config)!=null&&c.autoplay&&!t&&(this.playlistModel.meta.config.autoplay=!1),(f=(p=this.playlistModel.meta)==null?void 0:p.config)!=null&&f.repeat&&!t&&(this.playlistModel.meta.config.repeat=!1),(m=(x=this.playlistModel.meta)==null?void 0:x.config)!=null&&m.shuffle&&!t&&(this.playlistModel.meta.config.shuffle=!1),(y=(g=this.playlistModel.meta)==null?void 0:g.config)!=null&&y.showSearch&&!t&&(this.playlistModel.meta.config.showSearch=!1)}}class T extends P{constructor(t){super(t)}}class B extends P{constructor(t){super(t)}}class _{constructor(t){this.playlistModel=t}init(){this.initPlaylist()}initPlaylist(){const t=this.playlistModel.type;t==="audio"?new T(this.playlistModel).init():t==="video"&&new B(this.playlistModel).init()}}jQuery(document).ready(function(n){jQuery(".autocraft_player-playlist-wrapper").each(function(){const e=jQuery(this).data("playlist-instance"),s=window[e];s&&new _(s).init()})});
