<?php

if (!defined('ABSPATH')) {
    exit;
}

use AutoCraftPlayer\Framework\Support\Arr;

$id              = Arr::get($playlist, 'id');
$playlistType    = Arr::get($playlist, 'type');
$instance        = Arr::get($playlist, 'instance');
$theme           = Arr::get($playlist, 'meta.config.theme', 'default');
$prefix = 'autocraft_player-playlist';
$playlistClasses = "$prefix $prefix-$theme $prefix-$id $prefix-$playlistType $instance";
?>

<div class="autocraft_player-playlist-wrapper" data-playlist-instance="<?php
echo esc_attr($instance) ?>">
    <div class="<?php
    echo esc_attr($playlistClasses); ?>" id="<?php
    echo esc_attr($instance . '_' . $id); ?>">
        <?php
        if ($playlistType === 'video') {
            include AUTOCRAFT_PLAYER_PLUGIN_DIR . 'app/Views/public/player/player-type/video.php';
        } elseif ($playlistType === 'audio') {
            include AUTOCRAFT_PLAYER_PLUGIN_DIR . 'app/Views/public/player/player-type/audio.php';
        }
        ?>
    </div>
</div>
