<?php

if (!defined('ABSPATH')) {
    exit;
}
?>
<!doctype html>
<html lang="<?php
language_attributes(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php
        esc_attr_e('AutoCraft Player', 'autocraft-player') ?></title>
    <?php
    wp_head(); ?>
</head>
<body>
<div class="autocraft_player_preview">
    <div class="autocraft_player_preview_header">
        <div class="autocraft_player_preview_header_action">
            <a href="<?php
            echo esc_url($editUrl) ?>">
                <?php
                esc_attr_e('Edit', 'autocraft-player') ?>
            </a>
        </div>
        <div class="autocraft_player_preview_header_title">
            <ul>
                <li><?php
                    echo esc_html($shortcode) ?></li>
            </ul>
        </div>
    </div>

    <div class="autocraft_player_preview_body">
        <div class="autocraft_player_preview_body_wrapper">
            <?php
            echo wp_kses_post(do_shortcode($shortcode)); ?>
        </div>
    </div>
    <div class="autocraft_player_preview_footer">
        <p class="autocraft_player_preview_footer_text">
            <?php
            esc_html_e(
                'You are seeing a preview version of AutoCraft Player. This content is only accessible to Admin users. Other users may not access this page. To use this in a page, please use the following shortcode:',
                'autocraft-player'
            ); ?>
            <code><?php echo esc_html($shortcode); ?></code>
        </p>
    </div>
</div>
<?php
wp_footer(); ?>
</body>
</html>
