<?php

namespace AutoCraftPlayer\App\Models;

class Video extends Medium
{
    const MEDIA_TYPE = 'video';

    public static function boot()
    {
        parent::boot();
        static::addGlobalScope('type', function ($builder) {
            $builder->where('type', 'video');
        });

        static::retrieved(function ($video) {
            if ($video->provider === 'local') {
                $video->load('video');
            }
        });

        static::deleting(function ($video) {
            $video->deleteFile();
        });
    }

    public function video()
    {
        return $this->belongsTo(Upload::class, 'id', 'object_id')
                    ->where('object_type', 'video');
    }

    public function deleteFile()
    {
        if ($this->provider === 'local') {
            $this->video()->delete();
            $this->image()->delete();
        } else {
            do_action('autocraft_player/delete_remote_media_' . $this->provider, $this);
        }
    }
}
