<?php

namespace AutoCraftPlayer\App\Models;

class Upload extends Model
{
    protected $table = 'autocraft_player_uploads';

    protected $primaryKey = 'id';

    protected $hidden = ['file_path'];

    protected $fillable = [
        'user_id',
        'object_id',
        'uid',
        'object_type',
        'mime_type',
        'file_path',
        'url',
        'meta',
        'is_active'
    ];

    public static function boot()
    {
        parent::boot();

        static::deleting(function ($thumbnail) {
            $thumbnail->deleteFile();
        });
    }

    public function getMetaAttribute($value)
    {
        return maybe_unserialize($value);
    }

    public function setMetaAttribute($value)
    {
        $this->attributes['meta'] = maybe_serialize($value);
    }

    public function deleteFile()
    {
        if (file_exists($this->file_path)) {
            wp_delete_file($this->file_path);
        }
    }

    public static function updateObjectIdById($id, $objectId)
    {
        $upload = Upload::find($id);

        if ($upload) {
            $upload->update([
                'is_active' => 1,
                'object_id' => intval($objectId)
            ]);
        }

        return $upload;
    }
}
