<?php

namespace AutoCraftPlayer\App\Models;

class Playlist extends Model
{
    protected $table = 'autocraft_player_playlists';

    protected $primaryKey = 'id';

    protected $appends = ['media_count'];

    protected $with = ['image'];

    protected $fillable = [
        'uid',
        'title',
        'slug',
        'description',
        'meta',
        'privacy',
        'status',
        'default_media_order',
        'type',
        'parent_id',
        'user_id',
        'created_at',
        'updated_at',
    ];

    public function getMetaAttribute($value)
    {
        if (empty($value)) {
            return [];
        }

        return json_decode($value, true);
    }

    public function setMetaAttribute($value)
    {
        $this->attributes['meta'] = wp_json_encode($value);
    }

    public function getUpdatedAtAttribute($value)
    {
        return gmdate('Y-m-d', strtotime($value));
    }

    public function getMediaCountAttribute()
    {
        return $this->media()->count();
    }

    public function playlistItems()
    {
        return $this->hasMany(PlaylistItem::class, 'playlist_id', 'id');
    }

    public function media()
    {
        return $this->belongsToMany(Medium::class, 'autocraft_player_playlist_items', 'playlist_id', 'medium_id')
                    ->withPivot('position', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'ID');
    }

    public function image()
    {
        return $this->belongsTo(Upload::class, 'id', 'object_id')
                    ->where('object_type', 'image');
    }
}
