<?php
//phpcs:disable
namespace AutoCraftPlayer\App\Models;

use AutoCraftPlayer\App\Helpers\ValueFormatter;

class Meta extends Model
{
    protected $table = 'autocraft_player_meta';
    protected $primaryKey = 'id';
    protected $fillable = ['meta_key', 'meta_value', 'object_type', 'object_id'];

    public static function updateMeta($key, $value, $objectType, $objectId = null)
    {
        return static::updateOrCreate(
            [
                'meta_key'    => $key,
                'object_type' => $objectType,
                'object_id'   => $objectId
            ],
            [
                'meta_value' => $value
            ]
        );
    }

    public static function getMeta($key, $objectType, $objectId = null)
    {
        return static::where('meta_key', $key)
                     ->where('object_type', $objectType)
                     ->where('object_id', $objectId)
                     ->first();
    }

    public static function getMetaByKey($key)
    {
        return static::where('key', $key)->get();
    }

    public static function getMetaByObjectType($objectType)
    {
        return static::where('object_type', $objectType)->get();
    }

    public function getMetaValueAttribute()
    {
        return json_decode($this->attributes['meta_value'], true);
    }

    public function setMetaValueAttribute($value)
    {
        $value                          = ValueFormatter::formatRequestData($value);
        $this->attributes['meta_value'] = wp_json_encode($value);
    }
}
