<?php

namespace AutoCraftPlayer\App\Models;

class Medium extends Model
{
    protected $table = 'autocraft_player_media';

    protected $primaryKey = 'id';

    protected $with = ['image'];

    protected $fillable = [
        'uid',
        'user_id',
        'title',
        'slug',
        'type',
        'description',
        'privacy',
        'status',
        'provider',
        'url',
        'meta'
    ];

    public function getMetaAttribute($value)
    {
        if (empty($value)) {
            return [];
        }
        return json_decode($value, true);
    }

    public function setMetaAttribute($value)
    {
        $this->attributes['meta'] = wp_json_encode($value);
    }

    public function getCreatedAtAttribute($value)
    {
        return gmdate('Y-m-d', strtotime($value));
    }

    public function playlists()
    {
        return $this->belongsToMany(Playlist::class, 'autocraft_player_playlist_items', 'medium_id', 'playlist_id')
                    ->withPivot('position');
    }

    public function image()
    {
        return $this->belongsTo(Upload::class, 'id', 'object_id')
                    ->where('object_type', 'image');
    }
}
