<?php

namespace AutoCraftPlayer\App\Models;

class Audio extends Medium
{
    const MEDIA_TYPE = 'audio';

    public static function boot()
    {
        parent::boot();
        static::addGlobalScope('audio', function ($builder) {
            $builder->where('type', 'audio');
        });

        static::retrieved(function ($audio) {
            if ($audio->provider === 'local') {
                $audio->load('audio');
            }
        });

        static::deleting(function ($audio) {
            $audio->deleteFile();
        });
    }

    public function audio()
    {
        return $this->belongsTo(Upload::class, 'id', 'object_id')
                    ->where('object_type', 'audio');
    }

    public function deleteFile()
    {
        if ($this->provider === 'local') {
            $this->audio()->delete();
            $this->image()->delete();
        } else {
            do_action('autocraft_player/delete_remote_media_' . $this->provider, $this);
        }
    }
}
