<?php

namespace AutoCraftPlayer\App\Http\Requests;

use AutoCraftPlayer\Framework\Foundation\Http\FormRequest;

class PlaylistRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'title'       => 'required|string|max:150',
            'description' => 'string|max:5000',
            'type'        => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            //
        ];
    }

    public function sanitizers(): array
    {
        return [
            'id'                  => 'intval',
            'title'               => 'sanitize_text_field',
            'description'         => 'sanitize_text_field',
            'type'                => 'sanitize_text_field',
            'privacy'             => 'sanitize_text_field',
            'status'              => 'sanitize_text_field',
            'default_media_order' => 'sanitize_text_field',
            'meta'                => '\AutoCraftPlayer\sanitizeArray',
            'parent_id'           => 'intval'
        ];
    }
}
