<?php

namespace AutoCraftPlayer\App\Http\Requests;

use AutoCraftPlayer\Framework\Foundation\Http\FormRequest;

class MediumRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'title'       => 'required|string|max:150',
            'url'         => 'required|string|max:5000',
            'description' => 'string|max:5000',
        ];
    }

    public function messages(): array
    {
        return [
            //
        ];
    }

    public function sanitizers(): array
    {
        return [
            'id'          => 'intval',
            'title'       => 'sanitize_text_field',
            'description' => 'sanitize_text_field',
            'type'        => 'sanitize_text_field',
            'url'         => 'sanitize_url',
            'privacy'     => 'sanitize_text_field',
            'status'      => 'sanitize_text_field',
            'provider'    => 'sanitize_text_field',
            'path'        => 'sanitize_text_field',
            'meta'        => '\AutoCraftPlayer\sanitizeArray',
        ];
    }
}
