<?php

namespace AutoCraftPlayer\App\Http\Middleware;

use AutoCraftPlayer\Framework\Support\Facades\Config;
use Closure;
use AutoCraftPlayer\Framework\Http\Request;

class Authentication
{
    public function handle(Request $request, Closure $next)
    {
        // Todo: need to remove it's only for development
        if (Config::get('app.env') === 'dev') {
            return $next($request);
        }

        if (current_user_can(\AutoCraftPlayer\adminRole())) {
            return $next($request);
        }

        wp_send_json([
            'message' => __('Unauthorized Access', 'autocraft-player')
        ], 401);
    }
}
