<?php

namespace AutoCraftPlayer\App\Http\Controllers;

use AutoCraftPlayer\App\Http\Controllers\Controller;
use AutoCraftPlayer\App\Models\PlaylistItem;
use AutoCraftPlayer\Framework\Http\Request;
use AutoCraftPlayer\Framework\Support\Arr;

class PlaylistItemController extends Controller
{
    public function index(Request $request, $playlistId)
    {
        return [
            'message' => __('Playlist items retrieved successfully', 'autocraft-player'),
            'data'    => PlaylistItem::all()
        ];
    }

    public function create()
    {
    }

    public function store(Request $request)
    {
    }

    public function show(int $id)
    {
    }

    public function edit(int $id)
    {
    }

    public function update(Request $request, int $id)
    {
    }

    public function destroy(int $id)
    {
        $playlistItem = PlaylistItem::findOrFail($id);
        $playlistItem->delete();

        return [
            'message' => __('Playlist item deleted successfully', 'autocraft-player')
        ];
    }
}
