<?php

namespace AutoCraftPlayer\App\Http\Controllers;

use AutoCraftPlayer\App\Models\Medium;
use AutoCraftPlayer\App\Models\Playlist;
use AutoCraftPlayer\Framework\Http\Request;

class DashboardController extends Controller
{
    public function stats()
    {
        $videoCount    = Medium::where('type', 'video')->count();
        $audioCount    = Medium::where('type', 'audio')->count();
        $playlistCount = Playlist::count();
        $totalMedia    = Medium::count();

        return [
            'data' => [
                'total_videos'    => $videoCount,
                'total_audios'    => $audioCount,
                'total_playlists' => $playlistCount,
                'total_media'     => $totalMedia,
            ]
        ];
    }

    public function index()
    {
    }

    public function create()
    {
    }

    public function store(Request $request)
    {
    }

    public function show(int $id)
    {
    }

    public function edit(int $id)
    {
    }

    public function update(Request $request, int $id)
    {
    }

    public function destroy(int $id)
    {
    }
}
