<?php

namespace AutoCraftPlayer\App\Hooks\Handlers;

use AutoCraftPlayer\Framework\Support\Arr;

class VideoHandler
{
    public function init()
    {
        add_filter('autocraft_player/global_settings/video/before_get', [$this, 'formatConfig']);
    }

    public function formatConfig($config)
    {
        $playbackRates = Arr::get($config, 'playbackRates', []);
        sort($playbackRates);

        $config['playbackRates'] = $playbackRates;

        return $config;
    }
}
