<?php

namespace AutoCraftPlayer\App\Hooks\Handlers;

use AutoCraftPlayer\App\Helpers\MediaHelper;
use AutoCraftPlayer\App\Vite;
use AutoCraftPlayer\Framework\Support\Arr;

class ScriptHandler
{
    public function register()
    {
        add_action('autocraft_player/after_enqueue_player_assets', [$this, 'enqueuePlayerAssets'], 10, 1);
        add_action('autocraft_player/after_enqueue_playlist_assets', [$this, 'enqueuePlaylistAssets'], 10, 1);
        add_action('parse_request', [$this, 'parseRequest'], 10, 0);
    }

    public function enqueuePlaylistAssets($playlist)
    {
        $layout = Arr::get($playlist->meta, 'playerConfig.layout', 'default');

        $this->enqueuePlayerCss($layout);
        $this->enqueuePlayerJs();
    }

    public function enqueuePlayerAssets($player)
    {
        $layout = Arr::get($player->meta, 'config.layout', 'default');
        $this->enqueuePlayerCss($layout);
        $this->enqueuePlayerJs();
    }

    public function parseRequest()
    {
        if (isset($_GET['autocraft_player_share']) && isset($_GET['type'])) {
            $sharePageId = Arr::get(MediaHelper::getConfigByType('general'), 'selected_page_id', 0);

            if (!$sharePageId) {
                wp_die(
                    '<p>Please select a page from <strong>Global Settings > General</strong>. The selected page must include the <code>[autocraft_player_share_page]</code> shortcode.</p>'
                );
            }

            $page = get_post($sharePageId);

            if (!$page) {
                wp_die('<p>The selected share page could not be found. Please select a valid page.</p>');
            }

            if (!has_shortcode($page->post_content, 'autocraft_player_share_page')) {
                wp_die(
                    '<p>The page "<strong>' . esc_html(
                        $page->post_title
                    ) . '</strong>" does not contain the <code>[autocraft_player_share_page]</code> shortcode. Please add this shortcode to the page.</p>'
                );
            }

            global $wp_query;
            $wp_query = new \WP_Query(['page_id' => $sharePageId]);
        }
    }

    private function enqueuePlayerCss($layout)
    {
        if (in_array($layout, ['forest', 'sea', 'city', 'fantasy'])) {
            wp_enqueue_style("autocraft-{$layout}-theme", Vite::getAssetsUrl() . "libs/videojs/themes/{$layout}.css");
        }
    }

    private function enqueuePlayerJs()
    {
        Vite::enqueueScript(
            'autocraft_player-player-init-js',
            'public/js/player.init.js',
            ['autocraft_player-video-js'],
            AUTOCRAFT_PLAYER_VERSION,
            true
        );
    }
}
