<?php

namespace AutoCraftPlayer\App\Hooks\Handlers;

use AutoCraftPlayer\App\App;
use AutoCraftPlayer\App\Vite;
use AutoCraftPlayer\Framework\Support\Facades\View;

class PreviewHandler
{
    public function handle()
    {
        if (!\AutoCraftPlayer\adminRole()) {
            return;
        }

        $request = \AutoCraftPlayer\request();

        if ($type = sanitize_text_field($request->get('autocraft_player_preview_type'))) {
            $id = intval($request->get('id'));

            if (!$id) {
                return;
            }

            if ($type === 'audio' || $type === 'video') {
                $shortcode = "[autocraft_player id=\"$id\"]";
                $editUrl   = admin_url("admin.php?page=autocraft-player#/" . $type . "s/$id/edit/");
            } elseif ($type === 'playlist') {
                $app = App::getInstance();
                wp_enqueue_script('jquery');
                wp_localize_script('jquery', 'autoCraftPlayer', $app->localizedScripts());
                $shortcode = "[autocraft_player_playlist id=\"$id\"]";
                $editUrl   = admin_url("admin.php?page=autocraft-player#/playlists/$id/edit/");
            } else {
                return;
            }

            Vite::enqueueStyle('autocraft_player_preview', 'scss/admin/preview.scss' );

            View::render('admin/preview/shortcode', compact('editUrl', 'shortcode'));
            exit();
        }
    }

    protected function getRestInfo(): array
    {
        $config    = App::getInstance('config');
        $nameSpace = $config->get('app.rest_namespace');
        $version   = $config->get('app.rest_version');
        $url       = esc_url(rest_url($nameSpace . '/' . $version));

        return [
            'nonce'     => wp_create_nonce('wp_rest'),
            'url'       => $url,
            'version'   => $version,
            'namespace' => $nameSpace,
        ];
    }
}
