<?php

namespace AutoCraftPlayer\App\Hooks\Handlers;

use AutoCraftPlayer\Database\DatabaseMigrator;

class ActivationHandler
{
    public function handle($networkWide = false): void
    {
        if ($networkWide && $this->isMultiSite()) {
            $this->networkActivation();
        } else {
            $this->singleSiteActivation();
        }
    }

    protected function singleSiteActivation(): void
    {
        DatabaseMigrator::run();
    }

    protected function isMultiSite(): bool
    {
        return function_exists('is_multisite') && is_multisite();
    }

    protected function networkActivation(): void
    {
        $sites = get_sites(array('fields' => 'ids'));

        foreach ($sites as $site_id) {
            switch_to_blog($site_id);
            $this->singleSiteActivation();
            restore_current_blog();
        }
    }
}
