<?php

namespace AutoCraftPlayer\App\Helpers;

class ValueFormatter
{
    public static function autoConvert($value)
    {
        if (is_null($value)) {
            return null;
        }

        if (is_array($value)) {
            return array_map([__CLASS__, 'autoConvert'], $value);
        }

        if (strtolower($value) === "true") {
            return true;
        } elseif (strtolower($value) === "false") {
            return false;
        }

        if (is_numeric($value) && strpos($value, '.') === false) {
            return intval($value);
        }

        if (is_numeric($value) && strpos($value, '.') !== false) {
            return floatval($value);
        }

        return $value;
    }

    public static function formatRequestData($data)
    {
        return array_map([__CLASS__, 'autoConvert'], $data);
    }
}
